package org.nakedobjects.plugins.dndviewer.viewer.view.help;

import org.nakedobjects.plugins.dndviewer.HelpViewer;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;


public class InternalHelpViewer implements HelpViewer {
    private final Viewer viewer;

    public InternalHelpViewer(final Viewer viewer) {
        this.viewer = viewer;
    }

    public void open(final Location location, final String name, final String description, final String help) {
        viewer.clearAction();

        final View helpView = new HelpView(name, description, help);
        location.add(20, 20);
        helpView.setLocation(location);

        viewer.setOverlayView(helpView);
    }

}
// Copyright (c) Naked Objects Group Ltd.
