package org.nakedobjects.plugins.dndviewer.viewer.view.message;

import java.util.StringTokenizer;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractButtonAction;
import org.nakedobjects.plugins.dndviewer.viewer.action.CancelAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dndviewer.viewer.debug.DebugOutput;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;


public class DetailedMessageViewSpecification implements ViewSpecification {

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content instanceof MessageContent && ((MessageContent) content).getDetail() != null;
    }

    public String getName() {
        return "Detailed Message";
    }

    public View createView(final Content content, final ViewAxis axis) {
        final ButtonAction actions[] = new ButtonAction[] { new AbstractButtonAction("Print...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.print("Print exception", extract(view));
            }
        }, new AbstractButtonAction("Save...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.saveToFile("Save exception", "Exception", extract(view));
            }
        }, new AbstractButtonAction("Copy") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.saveToClipboard(extract(view));
            }
        }, new CancelAction(),

        };
        //return new ButtonBorder(actions, new ScrollBorder(new DetailedMessageView(content, this, null)));
        return new ButtonBorder(actions, new DetailedMessageView(content, this, null));
    }

    private String extract(final View view) {
        final Content content = view.getContent();
        final String message = ((MessageContent) content).getMessage();
        final String heading = ((MessageContent) content).title();
        final String detail = ((MessageContent) content).getDetail();

        final StringBuffer text = new StringBuffer();
        text.append(heading);
        text.append("\n\n");
        text.append(message);
        text.append("\n\n");
        text.append(detail);
        text.append("\n\n");
        return text.toString();
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

class DetailedMessageView extends AbstractView {
    protected DetailedMessageView(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    @Override
    public Size getMaximumSize() {
        final Size size = new Size();
        size.extendHeight(Toolkit.getText("title").getTextHeight());
        size.extendHeight(30);

        final String message = ((MessageContent) getContent()).getMessage();
        size.ensureWidth(500);
        size.extendHeight(Toolkit.getText("normal").stringHeight(message, 500));
        size.extendHeight(30);

        final String detail = ((MessageContent) getContent()).getDetail();
        final StringTokenizer st = new StringTokenizer(detail, "\n\r");
        while (st.hasMoreTokens()) {
            final String line = st.nextToken();
            size.ensureWidth((line.startsWith("\t") ? 20 : 0) + Toolkit.getText("normal").stringWidth(line));
            size.extendHeight(Toolkit.getText("normal").getTextHeight());
        }

        size.extend(40, 20);
        return size;
    }

    @Override
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        final int left = 10;
        int y = 10 + Toolkit.getText("title").getAscent();
        final String message = ((MessageContent) getContent()).getMessage();
        final String heading = ((MessageContent) getContent()).title();
        final String detail = ((MessageContent) getContent()).getDetail();

        canvas.drawText(heading, left, y, Toolkit.getColor("black"), Toolkit.getText("title"));
        y += Toolkit.getText("title").getTextHeight();
        canvas.drawText(message, left, y, 500, Toolkit.getColor("black"), Toolkit.getText("normal"));

        y += Toolkit.getText("normal").stringHeight(message, 500);
        canvas.drawText(detail, left, y, 1000, Toolkit.getColor("primary1"), Toolkit.getText("normal"));
    }

    @Override
    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return ViewAreaType.VIEW;
    }
}
// Copyright (c) Naked Objects Group Ltd.
