package org.nakedobjects.plugins.dndviewer.viewer.view.message;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractButtonAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.focus.SubviewFocusManager;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;


public class MessageDialogSpecification implements ViewSpecification {

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content instanceof MessageContent;
    }

    public String getName() {
        return "Message Dialog";
    }

    public View createView(final Content content, final ViewAxis axis) {
        final ButtonAction actions[] = new ButtonAction[] { new CloseViewAction() };
        final View view = new ButtonBorder(actions, new MessageDialogView(
                (MessageContent) content, this, null));
        view.setFocusManager(new SubviewFocusManager(view));
        return view;
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }

    public static class CloseViewAction extends AbstractButtonAction {
        public CloseViewAction() {
            super("Close");
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            view.dispose();
        }
    }
}

class MessageDialogView extends AbstractView {
    private static final int MAX_TEXT_WIDTH = 400;
    private static final int LEFT = 20;
    private static final int RIGHT = 20;
    private static final int TOP = 15;
    private static final int PADDING = 10;
    private Image errorIcon;
    private FocusManager focusManager;

    protected MessageDialogView(final MessageContent content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
        final String iconName = ((MessageContent) getContent()).getIconName();
        errorIcon = ImageFactory.getInstance().loadIcon(iconName, 32, null);
        if (errorIcon == null) {
            errorIcon = ImageFactory.getInstance().loadDefaultIcon(32, null);
        }
    }

    @Override
    public Size getMaximumSize() {
        final Size size = new Size();

        final String message = ((MessageContent) getContent()).getMessage();
        final String heading = ((MessageContent) getContent()).title();

        size.ensureHeight(errorIcon.getHeight());
        size.extendWidth(Toolkit.getText("normal").stringWidth(message, MAX_TEXT_WIDTH));
        int textHeight = Toolkit.getText("title").getLineHeight();
        textHeight += Toolkit.getText("normal").stringHeight(message, MAX_TEXT_WIDTH);
        size.ensureHeight(textHeight);

        size.ensureWidth(Toolkit.getText("title").stringWidth(heading));

        size.extendWidth(errorIcon.getWidth());
        size.extendWidth(PADDING);

        size.extend(LEFT + RIGHT, TOP * 2);
        return size;
    }

    @Override
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        final String message = ((MessageContent) getContent()).getMessage();
        final String heading = ((MessageContent) getContent()).title();

        canvas.clearBackground(this, Toolkit.getColor("white"));

        canvas.drawImage(errorIcon, LEFT, TOP);

        final int x = LEFT + errorIcon.getWidth() + PADDING;
        int y = TOP + 3 + Toolkit.getText("normal").getAscent();
        if (!heading.equals("")) {
            canvas.drawText(heading, x, y, Toolkit.getColor("black"), Toolkit.getText("title"));
            y += Toolkit.getText("title").getLineHeight();
        }
        canvas.drawText(message, x, y, MAX_TEXT_WIDTH, Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    @Override
    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return ViewAreaType.VIEW;
    }

    @Override
    public FocusManager getFocusManager() {
        return focusManager == null ? super.getFocusManager() : focusManager;
    }

    @Override
    public void setFocusManager(final FocusManager focusManager) {
        this.focusManager = focusManager;
    }

}
// Copyright (c) Naked Objects Group Ltd.
