package org.nakedobjects.plugins.dndviewer.viewer.basic;

import java.awt.event.InputEvent;

import org.junit.Ignore;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.DummyViewSpecification;
import org.nakedobjects.plugins.dndviewer.Feedback;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.NullContent;
import org.nakedobjects.plugins.dndviewer.TestToolkit;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.basic.PopupMenu;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;


public class PopupMenuTest extends ProxyJunit3TestCase {

    // private MockWorkspace workspace;
    private MockPopup popup;
    private PopupTargetView view;

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(PopupMenuTest.class);
    }

    @Test
    public void testNone() {
        // dummy
    }

    private Click click(final int x, final int y) {
        return new Click(popup, new Location(x, y), InputEvent.BUTTON1_MASK);
    }

    @Ignore("was commented out")
    @Test
    public void clickFirstOption() {
        assertFalse(view.action1.executed);
        popup.firstClick(click(10, 6));
        assertTrue(view.action1.executed);
    }

    @Ignore("was commented out")
    @Test
    public void clickSeparator() {
        popup.firstClick(click(10, 20));
        assertFalse(view.action1.executed);
        assertFalse(view.action3.executed);
        assertFalse(view.action4.executed);
    }

    @Ignore("was commented out")
    @Test
    public void clickThirdAction() {
        popup.firstClick(click(10, 58));
        assertTrue(view.action4.executed);
    }

    @Ignore("was commented out")
    @Test
    public void DefaultSelectedAtStartup() {
        assertEquals(0, popup.getOption());
    }

    @Ignore("was commented out")
    @Test
    public void mouseMoveOutsideBounds() {
        popup.mouseMoved(new Location(10, 70));
        assertEquals(3, popup.getOption());

        popup.mouseMoved(new Location(10, -10));
        assertEquals(0, popup.getOption());
    }

    @Ignore("was commented out")
    @Test
    public void mouseMoveOverFirstOption() {
        popup.mouseMoved(new Location(10, 2));
        assertEquals(0, popup.getOption());
    }

    @Ignore("was commented out")
    @Test
    public void mouseMoveOverSecondOption() {
        popup.mouseMoved(new Location(10, 18));
        assertEquals(1, popup.getOption());
    }

    @Ignore("was commented out")
    @Test
    public void optionCount() {
        assertEquals(4, popup.getOptionCount());
    }

    @Ignore("was commented out")
    @Test
    public void keyUpDown() {
        KeyboardAction action = new KeyboardAction(0, 0);

        popup.keyPressed(action);
        assertEquals(2, popup.getOption());

        popup.keyPressed(action);
        assertEquals(3, popup.getOption());

        popup.keyPressed(action);
        assertEquals(3, popup.getOption());

        popup.keyPressed(action);
        assertEquals(2, popup.getOption());

        popup.keyPressed(action);
        assertEquals(0, popup.getOption());

        popup.keyPressed(action);
        assertEquals(0, popup.getOption());
    }

    @Ignore("was commented out")
    @Test
    public void keyInvoke() {
        KeyboardAction action = new KeyboardAction(0, 0);

        popup.keyPressed(action);
        popup.keyPressed(action);

        assertFalse(view.action1.executed);
        assertTrue(view.action3.executed);
        assertFalse(view.action4.executed);
    }

    @Ignore("was commented out")
    @Test
    public void status() {
        popup.setOption(2);
        assertEquals("status option 3", popup.status);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();

        TestToolkit.createInstance();

        popup = new MockPopup();
        view = new PopupTargetView(new NullContent());

        popup.show(view, true, false, false);

        popup.layout(new Size());
    }

    private static class MockPopup extends PopupMenu {
        String status;

        @Override
        protected Color normalColor() {
            return new NullColor();
        }

        protected Color reverseColor() {
            return new NullColor();
        }

        @Override
        protected Color disabledColor() {
            return new NullColor();
        }

        @Override
        protected Text style() {
            return Toolkit.getText("debug");
        }

        protected void showStatus(final String status) {
            this.status = status;
        }

        @Override
        public void dispose() {}

        @Override
        public void markDamaged() {}
    }

    private static class PopupTargetView extends AbstractView {
        protected PopupTargetView(final Content content) {
            super(content, new DummyViewSpecification(), null);
        }

        MockUserAction action1;
        MockUserAction action3;
        MockUserAction action4;

        @Override
        public void contentMenuOptions(final UserActionSet options) {
            // UserActionSet options = new UserActionSet(false, false, UserAction.USER);

            action1 = new MockUserAction("option 1", UserAction.DEBUG);
            options.add(action1);
            action3 = new MockUserAction("option 3", UserAction.USER);
            options.add(action3);
            action4 = new MockUserAction("option 4", UserAction.USER);
            options.add(action4);

            // new UserAction[] { view.action1, view.action3, view.action4 }

        }

        @Override
        public Size getMaximumSize() {
            return null;
        }

        @Override
        public ViewAreaType viewAreaType(final Location location) {
            return ViewAreaType.CONTENT;
        }

        public View makeView(final NakedObject object, final NakedObjectAssociation field) throws CloneNotSupportedException {
            return null;
        }

        @Override
        public Workspace getWorkspace() {

            return new Workspace() {

                public View addIconFor(final NakedObject nakedObject, final Location at) {
                    return null;
                }

                public View createSubviewFor(final NakedObject object, final boolean asIcon) {
                    return null;
                }

                public void lower(final View view) {}

                public void raise(final View view) {}

                public void removeViewsFor(final NakedObject object) {}

                public void addView(final View view) {}

                public Consent canChangeValue() {
                    return Allow.DEFAULT;
                }

                public boolean canFocus() {
                    return false;
                }

                public boolean contains(final View view) {
                    return false;
                }

                public void contentMenuOptions(final UserActionSet menuOptions) {}

                public void debug(final DebugString debug) {}

                public void debugStructure(final DebugString debug) {}

                public void dispose() {}

                public void drag(final ContentDrag contentDrag) {}

                public void drag(final InternalDrag drag) {}

                public void dragCancel(final InternalDrag drag) {}

                public View dragFrom(final Location location) {
                    return null;
                }

                public void dragIn(final ContentDrag drag) {}

                public void dragOut(final ContentDrag drag) {}

                public Drag dragStart(final DragStart drag) {
                    return null;
                }

                public void dragTo(final InternalDrag drag) {}

                public void draw(final Canvas canvas) {}

                public void drop(final ContentDrag drag) {}

                public void drop(final ViewDrag drag) {}

                public void editComplete(boolean moveToNextField) {}

                public void entered() {}

                public void exited() {}

                public void firstClick(final Click click) {}

                public void focusLost() {}

                public void focusReceived() {}

                public Location getAbsoluteLocation() {
                    return new Location();
                }

                public int getBaseline() {
                    return 0;
                }

                public Bounds getBounds() {
                    return null;
                }

                public Content getContent() {
                    return null;
                }

                public int getId() {
                    return 0;
                }

                public Location getLocation() {
                    return null;
                }

                public Size getMaximumSize() {
                    return null;
                }

                public Padding getPadding() {
                    return new Padding();
                }

                public View getParent() {
                    return null;
                }

                public Size getRequiredSize(final Size maximumSize) {
                    return null;
                }

                public Size getSize() {
                    return null;
                }

                public ViewSpecification getSpecification() {
                    return null;
                }

                public ViewState getState() {
                    return null;
                }

                public View[] getSubviews() {
                    return null;
                }

                public View getView() {
                    return this;
                }

                public ViewAxis getViewAxis() {
                    return null;
                }

                public Viewer getViewManager() {
                    return null;
                }

                public Feedback getFeedbackManager() {
                    return null;
                }

                public Workspace getWorkspace() {
                    return null;
                }

                public boolean hasFocus() {
                    return false;
                }

                public View identify(final Location mouseLocation) {
                    return null;
                }

                public void invalidateContent() {}

                public void invalidateLayout() {}

                public void keyPressed(final KeyboardAction key) {}

                public void keyReleased(final int keyCode, final int modifiers) {}

                public void keyTyped(final char keyCode) {}

                public void layout(final Size maximumSize) {}

                public void limitBoundsWithin(final Size size) {}

                public void markDamaged() {}

                public void markDamaged(final Bounds bounds) {}

                public void mouseMoved(final Location location) {}

                public void objectActionResult(final NakedObject result, final Location at) {}

                public View pickupContent(final Location location) {
                    return null;
                }

                public View pickupView(final Location location) {
                    return null;
                }

                public void print(final Canvas canvas) {}

                public void refresh() {}

                public void removeView(final View view) {}

                public void replaceView(final View toReplace, final View replacement) {}

                public void secondClick(final Click click) {}

                public void setBounds(final Bounds bounds) {}

                public void setLocation(final Location point) {}

                public void setParent(final View view) {}

                public void setMaximumSize(final Size size) {}

                public void setSize(final Size size) {}

                public void setView(final View view) {}

                public View subviewFor(final Location location) {
                    return null;
                }

                public void thirdClick(final Click click) {}

                public void update(final NakedObject object) {}

                public void updateView() {}

                public ViewAreaType viewAreaType(final Location mouseLocation) {
                    return null;
                }

                public void viewMenuOptions(final UserActionSet menuOptions) {}

                public void mouseDown(final Click click) {}

                public void mouseUp(final Click click) {}

                public boolean containsFocus() {
                    return false;
                }

                public FocusManager getFocusManager() {
                    return null;
                }

                public void setFocusManager(final FocusManager focusManager) {}

                public void removeObject(final NakedObject object) {}

                public void addDialog(View dialog) {}

                public void addWindow(View window) {}

                public View addWindowFor(NakedObject object, Location at) {
                    return null;
                }
            };
        }
    }

    private static class MockUserAction implements UserAction {
        String name;
        boolean executed = false;
        private final NakedObjectActionType type;

        MockUserAction(final String name, final NakedObjectActionType type) {
            this.name = name;
            this.type = type;
        }

        public String getName(final View view) {
            return name;
        }

        public Consent disabled(final View view) {
            return new Allow(String.format("status %s", name));
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            executed = true;
        }

        public NakedObjectActionType getType() {
            return type;
        }

        public String getDescription(final View view) {
            return null;
        }

        public String getHelp(final View view) {
            return null;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
