/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import junit.textui.TestRunner;
import org.junit.Ignore;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.DummyViewSpecification;
import org.nakedobjects.plugins.dndviewer.Feedback;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.NullContent;
import org.nakedobjects.plugins.dndviewer.TestToolkit;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.basic.NullColor;
import org.nakedobjects.plugins.dndviewer.viewer.basic.PopupMenu;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;

public class PopupMenuTest
extends ProxyJunit3TestCase {
    private MockPopup popup;
    private PopupTargetView view;

    public static void main(String[] args) {
        TestRunner.run(PopupMenuTest.class);
    }

    @Test
    public void testNone() {
    }

    private Click click(int x, int y) {
        return new Click((View)this.popup, new Location(x, y), 16);
    }

    @Ignore(value="was commented out")
    @Test
    public void clickFirstOption() {
        PopupMenuTest.assertFalse((boolean)this.view.action1.executed);
        this.popup.firstClick(this.click(10, 6));
        PopupMenuTest.assertTrue((boolean)this.view.action1.executed);
    }

    @Ignore(value="was commented out")
    @Test
    public void clickSeparator() {
        this.popup.firstClick(this.click(10, 20));
        PopupMenuTest.assertFalse((boolean)this.view.action1.executed);
        PopupMenuTest.assertFalse((boolean)this.view.action3.executed);
        PopupMenuTest.assertFalse((boolean)this.view.action4.executed);
    }

    @Ignore(value="was commented out")
    @Test
    public void clickThirdAction() {
        this.popup.firstClick(this.click(10, 58));
        PopupMenuTest.assertTrue((boolean)this.view.action4.executed);
    }

    @Ignore(value="was commented out")
    @Test
    public void DefaultSelectedAtStartup() {
        PopupMenuTest.assertEquals((int)0, (int)this.popup.getOption());
    }

    @Ignore(value="was commented out")
    @Test
    public void mouseMoveOutsideBounds() {
        this.popup.mouseMoved(new Location(10, 70));
        PopupMenuTest.assertEquals((int)3, (int)this.popup.getOption());
        this.popup.mouseMoved(new Location(10, -10));
        PopupMenuTest.assertEquals((int)0, (int)this.popup.getOption());
    }

    @Ignore(value="was commented out")
    @Test
    public void mouseMoveOverFirstOption() {
        this.popup.mouseMoved(new Location(10, 2));
        PopupMenuTest.assertEquals((int)0, (int)this.popup.getOption());
    }

    @Ignore(value="was commented out")
    @Test
    public void mouseMoveOverSecondOption() {
        this.popup.mouseMoved(new Location(10, 18));
        PopupMenuTest.assertEquals((int)1, (int)this.popup.getOption());
    }

    @Ignore(value="was commented out")
    @Test
    public void optionCount() {
        PopupMenuTest.assertEquals((int)4, (int)this.popup.getOptionCount());
    }

    @Ignore(value="was commented out")
    @Test
    public void keyUpDown() {
        KeyboardAction action = new KeyboardAction(0, 0);
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)2, (int)this.popup.getOption());
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)3, (int)this.popup.getOption());
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)3, (int)this.popup.getOption());
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)2, (int)this.popup.getOption());
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)0, (int)this.popup.getOption());
        this.popup.keyPressed(action);
        PopupMenuTest.assertEquals((int)0, (int)this.popup.getOption());
    }

    @Ignore(value="was commented out")
    @Test
    public void keyInvoke() {
        KeyboardAction action = new KeyboardAction(0, 0);
        this.popup.keyPressed(action);
        this.popup.keyPressed(action);
        PopupMenuTest.assertFalse((boolean)this.view.action1.executed);
        PopupMenuTest.assertTrue((boolean)this.view.action3.executed);
        PopupMenuTest.assertFalse((boolean)this.view.action4.executed);
    }

    @Ignore(value="was commented out")
    @Test
    public void status() {
        this.popup.setOption(2);
        PopupMenuTest.assertEquals((String)"status option 3", (String)this.popup.status);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestToolkit.createInstance();
        this.popup = new MockPopup();
        this.view = new PopupTargetView((Content)new NullContent());
        this.popup.show((View)this.view, true, false, false);
        this.popup.layout(new Size());
    }

    private static class MockUserAction
    implements UserAction {
        String name;
        boolean executed = false;
        private final NakedObjectActionType type;

        MockUserAction(String name, NakedObjectActionType type) {
            this.name = name;
            this.type = type;
        }

        public String getName(View view) {
            return this.name;
        }

        public Consent disabled(View view) {
            return new Allow(String.format("status %s", this.name));
        }

        public void execute(Workspace workspace, View view, Location at) {
            this.executed = true;
        }

        public NakedObjectActionType getType() {
            return this.type;
        }

        public String getDescription(View view) {
            return null;
        }

        public String getHelp(View view) {
            return null;
        }
    }

    private static class PopupTargetView
    extends AbstractView {
        MockUserAction action1;
        MockUserAction action3;
        MockUserAction action4;

        protected PopupTargetView(Content content) {
            super(content, (ViewSpecification)new DummyViewSpecification(), null);
        }

        public void contentMenuOptions(UserActionSet options) {
            this.action1 = new MockUserAction("option 1", UserAction.DEBUG);
            options.add((UserAction)this.action1);
            this.action3 = new MockUserAction("option 3", UserAction.USER);
            options.add((UserAction)this.action3);
            this.action4 = new MockUserAction("option 4", UserAction.USER);
            options.add((UserAction)this.action4);
        }

        public Size getMaximumSize() {
            return null;
        }

        public ViewAreaType viewAreaType(Location location) {
            return ViewAreaType.CONTENT;
        }

        public View makeView(NakedObject object, NakedObjectAssociation field) throws CloneNotSupportedException {
            return null;
        }

        public Workspace getWorkspace() {
            return new Workspace(){

                public View addIconFor(NakedObject nakedObject, Location at) {
                    return null;
                }

                public View createSubviewFor(NakedObject object, boolean asIcon) {
                    return null;
                }

                public void lower(View view) {
                }

                public void raise(View view) {
                }

                public void removeViewsFor(NakedObject object) {
                }

                public void addView(View view) {
                }

                public Consent canChangeValue() {
                    return Allow.DEFAULT;
                }

                public boolean canFocus() {
                    return false;
                }

                public boolean contains(View view) {
                    return false;
                }

                public void contentMenuOptions(UserActionSet menuOptions) {
                }

                public void debug(DebugString debug) {
                }

                public void debugStructure(DebugString debug) {
                }

                public void dispose() {
                }

                public void drag(ContentDrag contentDrag) {
                }

                public void drag(InternalDrag drag) {
                }

                public void dragCancel(InternalDrag drag) {
                }

                public View dragFrom(Location location) {
                    return null;
                }

                public void dragIn(ContentDrag drag) {
                }

                public void dragOut(ContentDrag drag) {
                }

                public Drag dragStart(DragStart drag) {
                    return null;
                }

                public void dragTo(InternalDrag drag) {
                }

                public void draw(Canvas canvas) {
                }

                public void drop(ContentDrag drag) {
                }

                public void drop(ViewDrag drag) {
                }

                public void editComplete(boolean moveToNextField) {
                }

                public void entered() {
                }

                public void exited() {
                }

                public void firstClick(Click click) {
                }

                public void focusLost() {
                }

                public void focusReceived() {
                }

                public Location getAbsoluteLocation() {
                    return new Location();
                }

                public int getBaseline() {
                    return 0;
                }

                public Bounds getBounds() {
                    return null;
                }

                public Content getContent() {
                    return null;
                }

                public int getId() {
                    return 0;
                }

                public Location getLocation() {
                    return null;
                }

                public Size getMaximumSize() {
                    return null;
                }

                public Padding getPadding() {
                    return new Padding();
                }

                public View getParent() {
                    return null;
                }

                public Size getRequiredSize(Size maximumSize) {
                    return null;
                }

                public Size getSize() {
                    return null;
                }

                public ViewSpecification getSpecification() {
                    return null;
                }

                public ViewState getState() {
                    return null;
                }

                public View[] getSubviews() {
                    return null;
                }

                public View getView() {
                    return this;
                }

                public ViewAxis getViewAxis() {
                    return null;
                }

                public Viewer getViewManager() {
                    return null;
                }

                public Feedback getFeedbackManager() {
                    return null;
                }

                public Workspace getWorkspace() {
                    return null;
                }

                public boolean hasFocus() {
                    return false;
                }

                public View identify(Location mouseLocation) {
                    return null;
                }

                public void invalidateContent() {
                }

                public void invalidateLayout() {
                }

                public void keyPressed(KeyboardAction key) {
                }

                public void keyReleased(int keyCode, int modifiers) {
                }

                public void keyTyped(char keyCode) {
                }

                public void layout(Size maximumSize) {
                }

                public void limitBoundsWithin(Size size) {
                }

                public void markDamaged() {
                }

                public void markDamaged(Bounds bounds) {
                }

                public void mouseMoved(Location location) {
                }

                public void objectActionResult(NakedObject result, Location at) {
                }

                public View pickupContent(Location location) {
                    return null;
                }

                public View pickupView(Location location) {
                    return null;
                }

                public void print(Canvas canvas) {
                }

                public void refresh() {
                }

                public void removeView(View view) {
                }

                public void replaceView(View toReplace, View replacement) {
                }

                public void secondClick(Click click) {
                }

                public void setBounds(Bounds bounds) {
                }

                public void setLocation(Location point) {
                }

                public void setParent(View view) {
                }

                public void setMaximumSize(Size size) {
                }

                public void setSize(Size size) {
                }

                public void setView(View view) {
                }

                public View subviewFor(Location location) {
                    return null;
                }

                public void thirdClick(Click click) {
                }

                public void update(NakedObject object) {
                }

                public void updateView() {
                }

                public ViewAreaType viewAreaType(Location mouseLocation) {
                    return null;
                }

                public void viewMenuOptions(UserActionSet menuOptions) {
                }

                public void mouseDown(Click click) {
                }

                public void mouseUp(Click click) {
                }

                public boolean containsFocus() {
                    return false;
                }

                public FocusManager getFocusManager() {
                    return null;
                }

                public void setFocusManager(FocusManager focusManager) {
                }

                public void removeObject(NakedObject object) {
                }

                public void addDialog(View dialog) {
                }

                public void addWindow(View window) {
                }

                public View addWindowFor(NakedObject object, Location at) {
                    return null;
                }
            };
        }
    }

    private static class MockPopup
    extends PopupMenu {
        String status;

        private MockPopup() {
        }

        protected Color normalColor() {
            return new NullColor();
        }

        protected Color reverseColor() {
            return new NullColor();
        }

        protected Color disabledColor() {
            return new NullColor();
        }

        protected Text style() {
            return Toolkit.getText((String)"debug");
        }

        protected void showStatus(String status) {
            this.status = status;
        }

        public void dispose() {
        }

        public void markDamaged() {
        }
    }
}

