/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.dndviewer.DummyView;
import org.nakedobjects.plugins.dndviewer.TestToolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.viewer.border.ScrollBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

@RunWith(value=JMock.class)
public class ScrollBorderTest {
    private Mockery mockery = new JUnit4Mockery();
    protected TemplateImageLoader mockTemplateImageLoader;
    protected SpecificationLoader mockSpecificationLoader;
    protected PersistenceSessionFactory mockPersistenceSessionFactory;
    private UserProfileLoader mockUserProfileLoader;
    protected AuthenticationManager mockAuthenticationManager;
    private List<Object> servicesList;

    @Before
    public void setUp() throws Exception {
        LogManager.getRootLogger().setLevel(Level.OFF);
        this.servicesList = Collections.emptyList();
        this.mockTemplateImageLoader = (TemplateImageLoader)this.mockery.mock(TemplateImageLoader.class);
        this.mockSpecificationLoader = (SpecificationLoader)this.mockery.mock(SpecificationLoader.class);
        this.mockUserProfileLoader = (UserProfileLoader)this.mockery.mock(UserProfileLoader.class);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(ScrollBorderTest.this.mockTemplateImageLoader);
                this.ignoring(ScrollBorderTest.this.mockSpecificationLoader);
                this.ignoring(ScrollBorderTest.this.mockUserProfileLoader);
                this.ignoring(ScrollBorderTest.this.mockPersistenceSessionFactory);
                this.ignoring(ScrollBorderTest.this.mockAuthenticationManager);
            }
        });
        TestToolkit.createInstance();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, (NakedObjectConfiguration)configuration, this.mockTemplateImageLoader, this.mockSpecificationLoader, this.mockAuthenticationManager, this.mockUserProfileLoader, this.mockPersistenceSessionFactory, this.servicesList);
        sessionFactory.init();
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
    }

    @Test
    public void testScrollBar() {
        ScrollBorder view = new ScrollBorder((View)new DummyView());
        view.setMaximumSize(new Size(100, 200));
        ViewAreaType type = view.viewAreaType(new Location(20, 190));
        Assert.assertEquals((Object)ViewAreaType.INTERNAL, (Object)type);
        type = view.viewAreaType(new Location(95, 20));
        Assert.assertEquals((Object)ViewAreaType.INTERNAL, (Object)type);
    }

    @Test
    public void testSetSizeSetsUpContentAndHeaderSizes() {
        DummyView contentView = new DummyView();
        contentView.setMaximumSize(new Size(300, 400));
        DummyView topHeader = new DummyView();
        topHeader.setMaximumSize(new Size(0, 20));
        DummyView leftHeader = new DummyView();
        leftHeader.setMaximumSize(new Size(30, 0));
        ScrollBorder scrollBorder = new ScrollBorder((View)contentView, (View)leftHeader, (View)topHeader);
        scrollBorder.setSize(new Size(100, 200));
        Assert.assertEquals((Object)new Size(300, 400), (Object)contentView.getSize());
        Assert.assertEquals((Object)new Size(300, 20), (Object)topHeader.getSize());
        Assert.assertEquals((Object)new Size(30, 400), (Object)leftHeader.getSize());
    }

    @Test
    public void testSetSizeSetsUpContentAndHeaderSizes2() {
        DummyView contentView = new DummyView();
        contentView.setMaximumSize(new Size(300, 400));
        DummyView topHeader = new DummyView();
        topHeader.setMaximumSize(new Size(0, 20));
        DummyView leftHeader = new DummyView();
        leftHeader.setMaximumSize(new Size(30, 0));
        ScrollBorder scrollBorder = new ScrollBorder((View)contentView, (View)leftHeader, (View)topHeader);
        scrollBorder.setSize(new Size(100, 200));
    }
}

