/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dndviewer.Comparator;
import org.nakedobjects.plugins.dndviewer.viewer.content.SimpleCollectionSorter;
import org.nakedobjects.plugins.dndviewer.viewer.content.TitleComparator;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;

public class SimpleCollectionSorterTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(SimpleCollectionSorterTest.class);
    }

    public void testSortByTitle() {
        NakedObject[] instances = new NakedObject[]{this.object("one"), this.object("two"), this.object("three"), this.object("four")};
        SimpleCollectionSorter sorter = new SimpleCollectionSorter();
        sorter.sort(instances, (Comparator)new TitleComparator(), false);
        SimpleCollectionSorterTest.assertEquals((String)"four", (String)instances[0].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"one", (String)instances[1].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"three", (String)instances[2].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"two", (String)instances[3].titleString());
    }

    public void testSortByTitleReversed() {
        NakedObject[] instances = new NakedObject[]{this.object("one"), this.object("two"), this.object("three"), this.object("four")};
        SimpleCollectionSorter sorter = new SimpleCollectionSorter();
        sorter.sort(instances, (Comparator)new TitleComparator(), true);
        SimpleCollectionSorterTest.assertEquals((String)"two", (String)instances[0].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"three", (String)instances[1].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"one", (String)instances[2].titleString());
        SimpleCollectionSorterTest.assertEquals((String)"four", (String)instances[3].titleString());
    }

    private NakedObject object(String string) {
        TestProxyNakedObject object = new TestProxyNakedObject();
        object.setupTitleString(string);
        return object;
    }
}

