/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.text;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlockTargetExample;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextContent;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextSelection;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

@RunWith(value=JMock.class)
public class MultilineTextFieldContentTest {
    private TextContent content;
    private Mockery mockery = new JUnit4Mockery();
    protected TemplateImageLoader mockTemplateImageLoader;
    protected SpecificationLoader mockSpecificationLoader;
    protected PersistenceSessionFactory mockPersistenceSessionFactory;
    private UserProfileLoader mockUserProfileLoader;
    protected AuthenticationManager mockAuthenticationManager;
    private List<Object> servicesList;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.servicesList = Collections.emptyList();
        this.mockTemplateImageLoader = (TemplateImageLoader)this.mockery.mock(TemplateImageLoader.class);
        this.mockSpecificationLoader = (SpecificationLoader)this.mockery.mock(SpecificationLoader.class);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockUserProfileLoader = (UserProfileLoader)this.mockery.mock(UserProfileLoader.class);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(MultilineTextFieldContentTest.this.mockTemplateImageLoader);
                this.ignoring(MultilineTextFieldContentTest.this.mockSpecificationLoader);
                this.ignoring(MultilineTextFieldContentTest.this.mockPersistenceSessionFactory);
                this.ignoring(MultilineTextFieldContentTest.this.mockUserProfileLoader);
                this.ignoring(MultilineTextFieldContentTest.this.mockAuthenticationManager);
            }
        });
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, (NakedObjectConfiguration)new PropertiesConfiguration(), this.mockTemplateImageLoader, this.mockSpecificationLoader, this.mockAuthenticationManager, this.mockUserProfileLoader, this.mockPersistenceSessionFactory, this.servicesList);
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        sessionFactory.init();
        TextBlockTargetExample target = new TextBlockTargetExample();
        this.content = new TextContent((TextBlockTarget)target, 4, 0);
        this.content.setText("Line one\nLine two\nLine three\nLine four that is long enough that it wraps");
    }

    @Test
    public void testDeleteOnSingleLine() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 1, 3));
        selection.extendTo(new CursorPosition(this.content, 1, 7));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line one\nLino\nLine three\nLine four that is long enough that it wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteOnSingleLineWithStartAndEndOutOfOrder() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 1, 7));
        selection.extendTo(new CursorPosition(this.content, 1, 3));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line one\nLino\nLine three\nLine four that is long enough that it wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteAcrossTwoLines() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 0, 6));
        selection.extendTo(new CursorPosition(this.content, 1, 6));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line owo\nLine three\nLine four that is long enough that it wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteAcrossThreeLines() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 0, 6));
        selection.extendTo(new CursorPosition(this.content, 2, 6));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line ohree\nLine four that is long enough that it wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteAcrossThreeLinesIncludingWrappedBlock() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 2, 5));
        selection.extendTo(new CursorPosition(this.content, 4, 5));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line one\nLine two\nLine enough that it wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteWithinWrappedBlock() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 5, 0));
        selection.extendTo(new CursorPosition(this.content, 5, 3));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line one\nLine two\nLine three\nLine four that is long enough that wraps", (Object)this.content.getText());
    }

    @Test
    public void testDeleteMultipleLinesWithinWrappedBlock() {
        TextSelection selection = new TextSelection(this.content);
        selection.resetTo(new CursorPosition(this.content, 3, 5));
        selection.extendTo(new CursorPosition(this.content, 5, 3));
        this.content.delete(selection);
        Assert.assertEquals((Object)"Line one\nLine two\nLine three\nLine wraps", (Object)this.content.getText());
    }

    @Test
    public void testLineBreaks() {
        Assert.assertEquals((long)6L, (long)this.content.getNoLinesOfContent());
        this.content.setNoDisplayLines(8);
        String[] lines = this.content.getDisplayLines();
        Assert.assertEquals((long)8L, (long)lines.length);
        Assert.assertEquals((Object)"Line one", (Object)lines[0]);
        Assert.assertEquals((Object)"Line two", (Object)lines[1]);
        Assert.assertEquals((Object)"Line three", (Object)lines[2]);
        Assert.assertEquals((Object)"Line four that is ", (Object)lines[3]);
        Assert.assertEquals((Object)"long enough that ", (Object)lines[4]);
        Assert.assertEquals((Object)"it wraps", (Object)lines[5]);
        Assert.assertEquals((Object)"", (Object)lines[6]);
        Assert.assertEquals((Object)"", (Object)lines[7]);
    }
}

