/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.text;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlock;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlockTargetExample;

public class TextBlockTest
extends TestCase {
    private TextBlock block;

    public static void main(String[] args) {
        TestRunner.run(TextBlockTest.class);
    }

    protected void setUp() throws Exception {
        LogManager.getRootLogger().setLevel(Level.OFF);
        TextBlockTargetExample user = new TextBlockTargetExample();
        this.block = new TextBlock((TextBlockTarget)user, "Now is the winter of our discontent made summer by this glorious sun of York", true);
    }

    public void testBreakBlock() {
        TextBlock newBlock = this.block.splitAt(1, 11);
        TextBlockTest.assertEquals((String)"Now is the winter ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"of our disc", (String)this.block.getLine(1));
        TextBlockTest.assertEquals((String)"ontent made summer ", (String)newBlock.getLine(0));
    }

    public void testCantInsertNewline() {
        try {
            this.block.insert(0, 4, "\n");
            TextBlockTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCountLine() {
        TextBlockTest.assertEquals((int)5, (int)this.block.noLines());
    }

    public void testDeletePartOfLine() {
        this.block.delete(0, 4, 0, 11);
        TextBlockTest.assertEquals((String)"Now winter of our ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"discontent made ", (String)this.block.getLine(1));
        this.block.delete(1, 3, 1, 10);
        TextBlockTest.assertEquals((String)"dis made summer by ", (String)this.block.getLine(1));
    }

    public void testDeleteLines() {
        this.block.delete(0, 4, 2, 12);
        TextBlockTest.assertEquals((String)"Now by this ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"glorious sun of York", (String)this.block.getLine(1));
    }

    public void testDeleteLeft() {
        this.block.deleteLeft(0, 3);
        TextBlockTest.assertEquals((String)"No is the winter of ", (String)this.block.getLine(0));
        this.block.deleteLeft(0, 17);
        TextBlockTest.assertEquals((String)"No is the winterof ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"our discontent ", (String)this.block.getLine(1));
        this.block.deleteLeft(1, 9);
        TextBlockTest.assertEquals((String)"our discntent ", (String)this.block.getLine(1));
    }

    public void testDeleteRight() {
        this.block.deleteRight(0, 3);
        TextBlockTest.assertEquals((String)"Nowis the winter of ", (String)this.block.getLine(0));
        this.block.deleteRight(0, 17);
        TextBlockTest.assertEquals((String)"Nowis the winter f ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"our discontent ", (String)this.block.getLine(1));
        this.block.deleteRight(1, 9);
        TextBlockTest.assertEquals((String)"our discotent ", (String)this.block.getLine(1));
    }

    public void testGetLine() {
        TextBlockTest.assertEquals((String)"Now is the winter ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"of our discontent ", (String)this.block.getLine(1));
        TextBlockTest.assertEquals((String)"made summer by ", (String)this.block.getLine(2));
        TextBlockTest.assertEquals((String)"this glorious sun ", (String)this.block.getLine(3));
        TextBlockTest.assertEquals((String)"of York", (String)this.block.getLine(4));
    }

    public void testGetText() {
        TextBlockTest.assertEquals((String)"Now is the winter of our discontent made summer by this glorious sun of York", (String)this.block.getText());
    }

    public void testInsert() {
        this.block.insert(0, 0, "Quote:");
        TextBlockTest.assertEquals((String)"Quote:Now is the ", (String)this.block.getLine(0));
        this.block.insert(1, 10, "y");
        TextBlockTest.assertEquals((String)"Quote:Now is the ", (String)this.block.getLine(0));
        TextBlockTest.assertEquals((String)"winter of your ", (String)this.block.getLine(1));
    }
}

