/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectApplicationException;
import org.nakedobjects.plugins.dndviewer.BackgroundTask;
import org.nakedobjects.plugins.dndviewer.View;

public final class BackgroundThread {
    private static final Logger LOG = Logger.getLogger(BackgroundTask.class);

    private BackgroundThread() {
    }

    public static void run(View view, BackgroundTask task) {
        BackgroundThread.newRun(view, task);
    }

    public static void newRun(final View view, final BackgroundTask task) {
        LOG.debug((Object)("creating background thread for task " + task));
        Thread t = new Thread("nofBackground"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    view.getState().setActive();
                    view.getFeedbackManager().setBusy(view, task);
                    BackgroundThread.scheduleRepaint(view);
                    LOG.debug((Object)("running background thread for task " + task));
                    task.execute();
                }
                catch (Throwable e) {
                    if (!(e instanceof NakedObjectApplicationException)) {
                        String message = "Error while running background task " + task.getName();
                        LOG.error((Object)message, e);
                    }
                    view.getFeedbackManager().showException(e);
                }
                finally {
                    view.getState().setInactive();
                    view.getFeedbackManager().clearBusy(view);
                    BackgroundThread.scheduleRepaint(view);
                }
            }
        };
        t.start();
    }

    private static void scheduleRepaint(View view) {
        view.markDamaged();
        view.getViewManager().scheduleRepaint();
    }
}

