/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer;

import java.util.Vector;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class UserActionSet
implements UserAction {
    private Color backgroundColor = Toolkit.getColor("debug.baseline");
    private final String groupName;
    private final boolean includeDebug;
    private final boolean includeExploration;
    private final Vector options = new Vector();
    private final NakedObjectActionType type;

    public UserActionSet(boolean includeExploration, boolean includeDebug, NakedObjectActionType type) {
        this.type = type;
        this.groupName = "";
        this.includeExploration = includeExploration;
        this.includeDebug = includeDebug;
    }

    public UserActionSet(String groupName, UserActionSet parent) {
        this.groupName = groupName;
        this.includeExploration = parent.includeExploration;
        this.includeDebug = parent.includeDebug;
        this.type = parent.type;
        this.backgroundColor = parent.getColor();
    }

    public UserActionSet(String groupName, UserActionSet parent, NakedObjectActionType type) {
        this.groupName = groupName;
        this.includeExploration = parent.includeExploration;
        this.includeDebug = parent.includeDebug;
        this.type = type;
        this.backgroundColor = parent.getColor();
    }

    public void add(UserAction option) {
        NakedObjectActionType section = option.getType();
        if (section == USER || this.includeExploration && section == EXPLORATION || this.includeDebug && section == DEBUG) {
            this.options.addElement(option);
        }
    }

    public Consent disabled(View view) {
        return Allow.DEFAULT;
    }

    public void execute(Workspace workspace, View view, Location at) {
    }

    public Color getColor() {
        return this.backgroundColor;
    }

    public String getDescription(View view) {
        return "";
    }

    public String getHelp(View view) {
        return "";
    }

    public UserAction[] getMenuOptions() {
        UserAction[] v = new UserAction[this.options.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (UserAction)this.options.elementAt(i);
        }
        return v;
    }

    public String getName(View view) {
        return this.groupName;
    }

    public NakedObjectActionType getType() {
        return this.type;
    }

    public void setColor(Color color) {
        this.backgroundColor = color;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("type", (Object)this.type);
        int size = this.options.size();
        for (int i = 0; i < size; ++i) {
            str.append(((UserAction)this.options.elementAt(i)).getClass() + " ,");
        }
        return str.toString();
    }
}

