/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractControlView;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;

public class Button
extends AbstractControlView {
    private static final int TEXT_PADDING = 12;
    private final int buttonHeight = 4 + Toolkit.getText("control").getTextHeight() + 4;
    private boolean over;
    private boolean pressed;

    public Button(ButtonAction action, View target) {
        super(action, target);
    }

    public boolean containsFocus() {
        return this.hasFocus();
    }

    public void draw(Canvas canvas) {
        boolean x = false;
        boolean y = false;
        View target = this.getParent();
        String text = this.action.getName(target);
        boolean vetoed = this.action.disabled(target).isVetoed();
        Color color = vetoed ? Toolkit.getColor("menu.disabled") : Toolkit.getColor("black");
        Color border = vetoed ? Toolkit.getColor("secondary3") : Toolkit.getColor("secondary2");
        Text style = Toolkit.getText("control");
        int buttonWidth = 12 + style.stringWidth(text) + 12;
        canvas.clearBackground(this, Toolkit.getColor("secondary3"));
        canvas.drawRectangle(0, 0, buttonWidth, this.buttonHeight, this.over & !vetoed ? Toolkit.getColor("primary1") : Toolkit.getColor("black"));
        canvas.draw3DRectangle(1, 1, buttonWidth - 2, this.buttonHeight - 2, border, !this.pressed);
        canvas.draw3DRectangle(2, 2, buttonWidth - 4, this.buttonHeight - 4, border, !this.pressed);
        if (((ButtonAction)this.action).isDefault()) {
            canvas.drawRectangle(3, 3, buttonWidth - 6, this.buttonHeight - 6, border);
        }
        if (this.hasFocus()) {
            canvas.drawRectangle(3, 3, buttonWidth - 6, this.buttonHeight - 6, Toolkit.getColor("white"));
        }
        canvas.drawText(text, 12, 0 + this.buttonHeight / 2 + style.getMidPoint(), color, style);
    }

    public void entered() {
        this.over = true;
        this.pressed = false;
        this.markDamaged();
        super.entered();
    }

    public void exited() {
        this.over = false;
        this.pressed = false;
        this.markDamaged();
        super.exited();
    }

    public Size getMaximumSize() {
        String text = this.action.getName(this.getView());
        int buttonWidth = 12 + Toolkit.getText("control").stringWidth(text) + 12;
        return new Size(buttonWidth, this.buttonHeight);
    }

    public void mouseDown(Click click) {
        View target = this.getParent();
        boolean vetoed = this.action.disabled(target).isVetoed();
        if (!vetoed) {
            this.pressed = true;
            this.markDamaged();
        }
    }

    public void mouseUp(Click click) {
        View target = this.getParent();
        boolean vetoed = this.action.disabled(target).isVetoed();
        if (!vetoed) {
            this.pressed = false;
            this.markDamaged();
        }
    }
}

