/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.DragViewOutline;

public class DragViewBorder
extends AbstractBorder {
    private final int handleWidth = 14;

    public DragViewBorder(View wrappedView) {
        this(1, wrappedView);
    }

    public DragViewBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size + 14;
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("SimpleBorder " + this.top + " pixels\n"));
        debug.append((Object)"           handle 14 pixels");
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void draw(Canvas canvas) {
        if (this.getState().isViewIdentified()) {
            Color color = Toolkit.getColor("secondary2");
            Size s = this.getSize();
            int width = s.getWidth();
            for (int i = 0; i < this.left; ++i) {
                canvas.drawRectangle(i, i, width - 2 * i - 1, s.getHeight() - 2 * i - 1, color);
            }
            int w2 = width - this.left - 2;
            int w3 = w2 - 14;
            for (int x = w2; x > w3; x -= 2) {
                canvas.drawLine(x, this.top, x, s.getHeight() - this.top, color);
            }
        }
        super.draw(canvas);
    }

    public String toString() {
        return this.wrappedView.toString() + "/SimpleBorder";
    }
}

