/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.ObjectView;

public class FallbackView
extends ObjectView {
    protected FallbackView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        int width = size.getWidth() - 1;
        int height = size.getHeight() - 1;
        canvas.drawSolidRectangle(0, 0, width, height, Toolkit.getColor("secondary3"));
        canvas.drawSolidRectangle(0, 0, 10, height, Toolkit.getColor("secondary2"));
        canvas.drawLine(10, 0, 10, height - 2, Toolkit.getColor("black"));
        canvas.drawRectangle(0, 0, width, height, Toolkit.getColor("black"));
        canvas.drawText(this.getContent().title(), 14, this.getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public int getBaseline() {
        return 14;
    }

    public Size getMaximumSize() {
        return new Size(150, 20);
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return true;
        }

        public View createView(Content content, ViewAxis axis) {
            return new FallbackView(content, this, axis);
        }

        public String getName() {
            return "Fallback";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }
}

