/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.View;

public class TableFocusManager
implements FocusManager {
    private int row;
    private int cell;
    private final View table;

    public TableFocusManager(View table) {
        this.table = table;
        this.focusInitialChildView();
    }

    public void focusNextView() {
        int j;
        View r = this.table.getSubviews()[this.row];
        View[] cells = r.getSubviews();
        for (j = this.cell + 1; j < cells.length; ++j) {
            if (!cells[j].canFocus()) continue;
            cells[this.cell].markDamaged();
            this.cell = j;
            cells[j].markDamaged();
            return;
        }
        ++this.row;
        if (this.row == this.table.getSubviews().length) {
            this.row = 0;
        }
        r = this.table.getSubviews()[this.row];
        cells = r.getSubviews();
        for (j = 0; j < cells.length; ++j) {
            if (!cells[j].canFocus()) continue;
            cells[this.cell].markDamaged();
            this.cell = j;
            cells[j].markDamaged();
            return;
        }
    }

    public void focusPreviousView() {
        int j;
        View r = this.table.getSubviews()[this.row];
        View[] cells = r.getSubviews();
        for (j = this.cell - 1; j >= 0; --j) {
            if (!cells[j].canFocus()) continue;
            cells[this.cell].markDamaged();
            this.cell = j;
            cells[j].markDamaged();
            return;
        }
        --this.row;
        if (this.row == -1) {
            this.row = this.table.getSubviews().length - 1;
        }
        r = this.table.getSubviews()[this.row];
        cells = r.getSubviews();
        for (j = cells.length - 1; j >= 0; --j) {
            if (!cells[j].canFocus()) continue;
            cells[this.cell].markDamaged();
            this.cell = j;
            cells[j].markDamaged();
            return;
        }
    }

    public void focusParentView() {
    }

    public void focusFirstChildView() {
    }

    public void focusLastChildView() {
    }

    public void focusInitialChildView() {
        this.cell = 0;
        this.row = 0;
        View[] rows = this.table.getSubviews();
        if (rows.length > 0) {
            this.row = 0;
            View[] cells = rows[0].getSubviews();
            for (int j = 0; j < cells.length; ++j) {
                if (!cells[j].canFocus()) continue;
                cells[this.cell].markDamaged();
                this.cell = j;
                cells[j].markDamaged();
                return;
            }
        }
    }

    public View getFocus() {
        View[] rows = this.table.getSubviews();
        if (this.row < 0 || this.row >= rows.length) {
            return this.table;
        }
        View rowView = rows[this.row];
        View[] cells = rowView.getSubviews();
        if (this.cell < 0 || this.cell >= cells.length) {
            return rowView;
        }
        return cells[this.cell];
    }

    public void setFocus(View view) {
        if (view == this.table) {
            return;
        }
        View[] rows = this.table.getSubviews();
        this.row = 0;
        while (this.row < rows.length) {
            View[] cells = rows[this.row].getSubviews();
            for (int j = 0; j < cells.length; ++j) {
                if (view != cells[j] || !cells[j].canFocus()) continue;
                cells[this.cell].markDamaged();
                this.cell = j;
                cells[j].markDamaged();
                return;
            }
            ++this.row;
        }
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("row", this.row);
        str.append("cell", this.cell);
        return str.toString();
    }
}

