/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.WindowControl;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.BorderDrawing;
import org.nakedobjects.plugins.dndviewer.viewer.border.SwingStyleWindowBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public abstract class AbstractWindowBorder
extends AbstractBorder {
    protected BorderDrawing borderRender = new SwingStyleWindowBorder();
    protected WindowControl[] controls;

    public AbstractWindowBorder(View enclosedView) {
        super(enclosedView);
        this.left = this.borderRender.getLeft();
        this.right = this.borderRender.getRight();
        this.top = this.borderRender.getTop();
        this.bottom = this.borderRender.getBottom();
    }

    public void debugDetails(DebugString debug) {
        this.borderRender.debugDetails(debug);
        super.debugDetails(debug);
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            View dragOverlay = Toolkit.getViewFactory().createDragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    protected void setControls(WindowControl[] controls) {
        this.controls = controls;
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.layoutControls(size);
    }

    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        this.layoutControls(bounds.getSize());
    }

    private void layoutControls(Size size) {
        this.borderRender.layoutControls(size, this.controls);
    }

    public void draw(Canvas canvas) {
        Bounds bounds = this.getBounds();
        canvas.drawSolidRectangle(3, 3, bounds.getWidth() - 6, bounds.getHeight() - 6, Toolkit.getColor("background.window." + this.getSpecification().getName()));
        boolean hasFocus = this.containsFocus();
        ViewState state = this.getState();
        this.borderRender.draw(canvas, this.getSize(), hasFocus, state, this.controls, this.title());
        for (int i = 0; this.controls != null && i < this.controls.length; ++i) {
            Canvas controlCanvas = canvas.createSubcanvas(this.controls[i].getBounds());
            this.controls[i].draw(controlCanvas);
        }
        super.draw(canvas);
    }

    protected abstract String title();

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        this.borderRender.getRequiredSize(size, this.title(), this.controls);
        return size;
    }

    public void secondClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            super.secondClick(click);
        }
    }

    public void thirdClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            super.thirdClick(click);
        }
    }

    public void firstClick(Click click) {
        View button = this.overControl(click.getLocation());
        if (button == null) {
            if (this.overBorder(click.getLocation())) {
                Workspace workspace = this.getWorkspace();
                if (workspace != null) {
                    if (click.button2()) {
                        workspace.lower(this.getView());
                    } else if (click.button1()) {
                        workspace.raise(this.getView());
                    }
                }
            } else {
                super.firstClick(click);
            }
        } else {
            button.firstClick(click);
        }
    }

    private View overControl(Location location) {
        for (int i = 0; i < this.controls.length; ++i) {
            WindowControl control = this.controls[i];
            if (!control.getBounds().contains(location)) continue;
            return control;
        }
        return null;
    }
}

