/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TitleText;

public class IconBorder
extends AbstractBorder {
    private static final Text TITLE_STYLE = Toolkit.getText("title");
    private final int baseline;
    private final int titlebarHeight;
    private final int padding = 0;
    private final IconGraphic icon = new IconGraphic((View)this, TITLE_STYLE);
    private final TitleText text = new ObjectTitleText(this, TITLE_STYLE);

    public IconBorder(View wrappedView) {
        super(wrappedView);
        this.top = this.titlebarHeight = this.icon.getSize().getHeight() + 1;
        this.baseline = this.icon.getBaseline() + 1;
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)("IconBorder " + this.left + " pixels\n"));
        debug.append((Object)("           titlebar " + (this.top - this.titlebarHeight) + " pixels"));
        super.debugDetails(debug);
    }

    public Drag dragStart(DragStart drag) {
        if (this.overBorder(drag.getLocation())) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        int x = this.left + HPADDING;
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(this.getSize()), this.baseline, Toolkit.getColor("debug.bounds.draw"));
        }
        this.icon.draw(canvas, x, this.baseline);
        x += this.icon.getSize().getWidth();
        this.text.draw(canvas, x += View.HPADDING, this.baseline);
        super.draw(canvas);
    }

    public int getBaseline() {
        return this.wrappedView.getBaseline() + this.baseline + this.titlebarHeight;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.left + this.icon.getSize().getWidth() + View.HPADDING + this.text.getSize().getWidth() + 0 + this.right);
        return size;
    }

    public void firstClick(Click click) {
        int y = click.getLocation().getY();
        if (y < this.top && click.button2()) {
            Location location = new Location(click.getLocationWithinViewer());
            this.getViewManager().showInOverlay(this.getContent(), location);
        } else {
            super.firstClick(click);
        }
    }

    public void secondClick(Click click) {
        int y = click.getLocation().getY();
        if (y < this.top) {
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            this.getWorkspace().addWindowFor(this.getContent().getNaked(), location);
        } else {
            super.secondClick(click);
        }
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        Bounds title = new Bounds(new Location(), this.icon.getSize());
        title.extendWidth(this.left);
        title.extendWidth(this.text.getSize().getWidth());
        if (title.contains(mouseLocation)) {
            return ViewAreaType.CONTENT;
        }
        return super.viewAreaType(mouseLocation);
    }

    public String toString() {
        return this.wrappedView.toString() + "/WindowBorder [" + this.getSpecification() + "]";
    }
}

