/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class LineBorder
extends AbstractBorder {
    private final Color color;
    private final int arcRadius;

    public LineBorder(View wrappedView) {
        this(1, wrappedView);
    }

    public LineBorder(int size, View wrappedView) {
        this(size, 0, Toolkit.getColor("black"), wrappedView);
    }

    public LineBorder(int size, int arcRadius, View wrappedView) {
        this(size, arcRadius, Toolkit.getColor("black"), wrappedView);
    }

    public LineBorder(Color color, View wrappedView) {
        this(1, 0, color, wrappedView);
    }

    public LineBorder(int width, Color color, View wrappedView) {
        this(width, 0, color, wrappedView);
    }

    public LineBorder(int width, int arcRadius, Color color, View wrappedView) {
        super(wrappedView);
        this.top = width;
        this.left = width;
        this.bottom = width;
        this.right = width;
        this.arcRadius = arcRadius;
        this.color = color;
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("LineBorder " + this.top + " pixels\n"));
    }

    public void draw(Canvas canvas) {
        Size s = this.getSize();
        int width = s.getWidth();
        for (int i = 0; i < this.left; ++i) {
            canvas.drawRoundedRectangle(i, i, width - 2 * i, s.getHeight() - 2 * i, this.arcRadius, this.arcRadius, this.color);
        }
        super.draw(canvas);
    }

    public String toString() {
        return this.wrappedView.toString() + "/LineBorder";
    }
}

