/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.SimpleInternalDrag;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractViewDecorator;
import org.nakedobjects.plugins.dndviewer.viewer.border.ScrollBar;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.DrawingUtil;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.NullView;

public class ScrollBorder
extends AbstractViewDecorator {
    private static final int CENTER = 3;
    private static final int NORTH = 1;
    private static final int SOUTH = 5;
    private static final int CORNER = 0;
    private static final int SCROLLBAR_WIDTH = 16;
    private static final int WEST = 2;
    private static final int EAST = 4;
    private final ScrollBar horizontalScrollBar = new ScrollBar();
    private final ScrollBar verticalScrollBar = new ScrollBar();
    protected int bottom = 16;
    protected int left;
    private View leftHeader;
    protected int right = 16;
    private Size size = new Size();
    protected int top;
    private View topHeader;
    private int dragArea = 3;
    private int offsetToThumbEdge;

    public ScrollBorder(View view) {
        this(view, new NullView(), new NullView());
    }

    public ScrollBorder(View content, View leftHeader, View topHeader) {
        super(content);
        this.horizontalScrollBar.setPostion(0);
        this.verticalScrollBar.setPostion(0);
        this.setLeftHeader(leftHeader);
        this.setTopHeader(topHeader);
    }

    public void setTopHeader(View topHeader) {
        this.topHeader = topHeader;
        topHeader.setParent(this.getView());
        this.top = topHeader.getRequiredSize(new Size()).getHeight();
    }

    public void setLeftHeader(View leftHeader) {
        this.leftHeader = leftHeader;
        leftHeader.setParent(this.getView());
        this.left = leftHeader.getRequiredSize(new Size()).getWidth();
    }

    private int adjust(Click click) {
        return this.adjust(click.getLocation());
    }

    private int adjust(ContentDrag drag) {
        return this.adjust(drag.getTargetLocation());
    }

    private int adjust(Location location) {
        Bounds contentArea = this.viewportArea();
        Offset offset = this.offset();
        int yOffset = offset.getDeltaY();
        int xOffset = offset.getDeltaX();
        if (contentArea.contains(location)) {
            location.subtract(this.left, this.top);
            location.add(xOffset, yOffset);
            return 3;
        }
        int x = location.getX();
        int y = location.getY();
        if (x > contentArea.getX2() && y >= contentArea.getY() && y <= contentArea.getY2()) {
            location.subtract(0, contentArea.getY());
            return 4;
        }
        if (y > contentArea.getY2() && x >= contentArea.getX() && x <= contentArea.getX2()) {
            location.subtract(contentArea.getX(), 0);
            return 5;
        }
        if (y < contentArea.getY() && x >= contentArea.getX() && x <= contentArea.getX2()) {
            location.subtract(this.left, 0);
            location.add(xOffset, 0);
            return 1;
        }
        if (x < contentArea.getX() && y >= contentArea.getY() && y <= contentArea.getY2()) {
            location.subtract(0, this.top);
            location.add(0, yOffset);
            return 2;
        }
        location.setX(-1);
        location.setY(-1);
        return 0;
    }

    protected Bounds viewportArea() {
        return new Bounds(this.left, this.top, this.getSize().getWidth() - this.left - this.right, this.getSize().getHeight() - this.top - this.bottom);
    }

    protected void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.append((Object)("\n           Top header: " + (this.topHeader == null ? "none" : this.topHeader.toString())));
        debug.append((Object)("\n           Left header: " + (this.leftHeader == null ? "none" : this.leftHeader.toString())));
        debug.append((Object)"\n           Vertical scrollbar ");
        debug.append((Object)("\n             offset " + this.top));
        debug.append((Object)("\n             position " + this.verticalScrollBar.getPosition()));
        debug.append((Object)("\n             minimum " + this.verticalScrollBar.getMinimum()));
        debug.append((Object)("\n             maximum " + this.verticalScrollBar.getMaximum()));
        debug.append((Object)("\n             visible amount " + this.verticalScrollBar.getVisibleAmount()));
        debug.append((Object)"\n           Horizontal scrollbar ");
        debug.append((Object)("\n             offset " + this.left));
        debug.append((Object)("\n             position " + this.horizontalScrollBar.getPosition()));
        debug.append((Object)("\n             minimum " + this.horizontalScrollBar.getMinimum()));
        debug.append((Object)("\n             maximum " + this.horizontalScrollBar.getMaximum()));
        debug.append((Object)("\n             visible amount " + this.horizontalScrollBar.getVisibleAmount()));
        debug.append((Object)("\n           Viewport area " + this.viewportArea()));
        debug.append((Object)("\n           Offset " + this.offset()));
    }

    public void drag(InternalDrag drag) {
        switch (this.dragArea) {
            case 1: {
                drag.getLocation().subtract(this.offset().getDeltaX(), this.top);
                this.topHeader.drag(drag);
                break;
            }
            case 2: {
                drag.getLocation().subtract(this.left, this.offset().getDeltaY());
                this.leftHeader.drag(drag);
                break;
            }
            case 3: {
                drag.getLocation().subtract(this.offset());
                this.wrappedView.drag(drag);
                break;
            }
            case 5: {
                int x = drag.getLocation().getX() - this.left;
                this.horizontalScrollBar.setPostion(x - this.offsetToThumbEdge);
                this.markDamaged();
                break;
            }
            case 4: {
                int y = drag.getLocation().getY() - this.top;
                this.verticalScrollBar.setPostion(y - this.offsetToThumbEdge);
                this.markDamaged();
                break;
            }
            default: {
                return;
            }
        }
    }

    public Drag dragStart(DragStart drag) {
        int area;
        this.dragArea = area = this.adjust(drag);
        switch (this.dragArea) {
            case 1: {
                return this.topHeader.dragStart(drag);
            }
            case 2: {
                return this.leftHeader.dragStart(drag);
            }
            case 3: {
                return this.wrappedView.dragStart(drag);
            }
            case 5: {
                return this.dragStartSouth(drag);
            }
            case 4: {
                return this.dragStartEast(drag);
            }
        }
        return null;
    }

    public void dragCancel(InternalDrag drag) {
        switch (this.dragArea) {
            case 1: {
                drag.getLocation().subtract(this.offset().getDeltaX(), this.top);
                this.topHeader.dragCancel(drag);
                break;
            }
            case 2: {
                drag.getLocation().subtract(this.left, this.offset().getDeltaY());
                this.leftHeader.dragCancel(drag);
                break;
            }
            case 3: {
                drag.getLocation().subtract(this.offset());
                this.wrappedView.dragCancel(drag);
            }
        }
    }

    public void dragTo(InternalDrag drag) {
        switch (this.dragArea) {
            case 1: {
                drag.getLocation().subtract(this.offset().getDeltaX(), this.top);
                this.topHeader.dragTo(drag);
                break;
            }
            case 2: {
                drag.getLocation().subtract(this.left, this.offset().getDeltaY());
                this.leftHeader.dragTo(drag);
                break;
            }
            case 3: {
                drag.getLocation().subtract(this.offset());
                this.wrappedView.dragTo(drag);
                break;
            }
        }
    }

    public View dragFrom(Location location) {
        this.adjust(location);
        switch (this.dragArea) {
            case 1: {
                return this.topHeader.dragFrom(location);
            }
            case 2: {
                return this.leftHeader.dragFrom(location);
            }
            case 3: {
                return this.wrappedView.dragFrom(location);
            }
        }
        return null;
    }

    public void dragIn(ContentDrag drag) {
        this.adjust(drag);
        switch (this.dragArea) {
            case 1: {
                this.topHeader.dragIn(drag);
                break;
            }
            case 2: {
                this.leftHeader.dragIn(drag);
                break;
            }
            case 3: {
                this.wrappedView.dragIn(drag);
                break;
            }
            default: {
                System.out.println(this + " ignored");
            }
        }
    }

    public void dragOut(ContentDrag drag) {
        this.adjust(drag);
        switch (this.dragArea) {
            case 1: {
                this.topHeader.dragOut(drag);
                break;
            }
            case 2: {
                this.leftHeader.dragOut(drag);
                break;
            }
            case 3: {
                this.wrappedView.dragOut(drag);
                break;
            }
        }
    }

    private Drag dragStartEast(DragStart drag) {
        Location location = drag.getLocation();
        int y = location.getY();
        if (this.verticalScrollBar.isOnThumb(y)) {
            this.offsetToThumbEdge = y - this.verticalScrollBar.getPosition();
            return new SimpleInternalDrag((View)this, new Offset(super.getAbsoluteLocation()));
        }
        return null;
    }

    private Drag dragStartSouth(DragStart drag) {
        Location location = drag.getLocation();
        int x = location.getX();
        if (this.horizontalScrollBar.isOnThumb(x)) {
            this.offsetToThumbEdge = x - this.horizontalScrollBar.getPosition();
            return new SimpleInternalDrag((View)this, new Offset(super.getAbsoluteLocation()));
        }
        return null;
    }

    private int adjust(DragStart drag) {
        return this.adjust(drag.getLocation());
    }

    public void draw(Canvas canvas) {
        Bounds contents = this.viewportArea();
        Offset offset = this.offset();
        int x = offset.getDeltaX();
        int y = offset.getDeltaY();
        int contentWidth = contents.getWidth();
        int contentHeight = contents.getHeight();
        Canvas headerCanvasLeft = canvas.createSubcanvas(0, this.top, this.left, contentHeight);
        headerCanvasLeft.offset(0, -y);
        this.leftHeader.draw(headerCanvasLeft);
        Canvas headerCanvasRight = canvas.createSubcanvas(this.left, 0, contentWidth, this.top);
        headerCanvasRight.offset(-x, 0);
        this.topHeader.draw(headerCanvasRight);
        Color thumbColor = Toolkit.getColor("primary2");
        this.drawHorizontalScrollBar(canvas, contentWidth, contentHeight, thumbColor);
        this.drawVerticalScrollBar(canvas, contentWidth, contentHeight, thumbColor);
        Canvas contentCanvas = canvas.createSubcanvas(this.left, this.top, contentWidth, contentHeight);
        contentCanvas.offset(-x, -y);
        if (Toolkit.debug) {
            canvas.drawRectangle(contents.getX(), contents.getY(), contents.getWidth(), contents.getHeight(), Toolkit.getColor("debug.bounds.draw"));
        }
        this.wrappedView.draw(contentCanvas);
        if (Toolkit.debug) {
            Size size = this.getSize();
            canvas.drawRectangle(0, 0, size.getWidth(), size.getHeight(), Toolkit.getColor("debug.bounds.view"));
            canvas.drawLine(0, size.getHeight() / 2, size.getWidth() - 1, size.getHeight() / 2, Toolkit.getColor("debug.bounds.view"));
            canvas.drawLine(0, this.getBaseline(), size.getWidth() - 1, this.getBaseline(), Toolkit.getColor("debug.baseline"));
        }
    }

    private void drawVerticalScrollBar(Canvas canvas, int contentWidth, int contentHeight, Color color) {
        int verticalVisibleAmount = this.verticalScrollBar.getVisibleAmount();
        int verticalScrollPosition = this.verticalScrollBar.getPosition();
        if (this.right > 0 && (verticalScrollPosition > this.top || verticalVisibleAmount < contentHeight)) {
            int x = contentWidth + this.left;
            canvas.drawSolidRectangle(x + 1, this.top, 15, contentHeight, Toolkit.getColor("secondary3"));
            canvas.drawSolidRectangle(x + 1, this.top + verticalScrollPosition, 14, verticalVisibleAmount, color);
            canvas.drawRectangle(x, this.top, 16, contentHeight, Toolkit.getColor("secondary2"));
            canvas.drawRectangle(x + 1, this.top + verticalScrollPosition, 14, verticalVisibleAmount, Toolkit.getColor("secondary1"));
            DrawingUtil.drawHatching(canvas, x + 3, this.top + verticalScrollPosition + 4, 10, verticalVisibleAmount - 8, Toolkit.getColor("primary1"), Toolkit.getColor("primary3"));
        }
    }

    private void drawHorizontalScrollBar(Canvas canvas, int contentWidth, int contentHeight, Color color) {
        int horizontalScrollPosition = this.horizontalScrollBar.getPosition();
        int horizontalVisibleAmount = this.horizontalScrollBar.getVisibleAmount();
        if (this.bottom > 0 && (horizontalScrollPosition > this.left || horizontalVisibleAmount < contentWidth)) {
            int y = contentHeight + this.top;
            canvas.drawSolidRectangle(this.left, y + 1, contentWidth, 15, Toolkit.getColor("secondary3"));
            int x = this.left + horizontalScrollPosition;
            canvas.drawSolidRectangle(x, y + 1, horizontalVisibleAmount, 14, color);
            canvas.drawRectangle(this.left, y, contentWidth, 16, Toolkit.getColor("secondary2"));
            canvas.drawRectangle(x, y + 1, horizontalVisibleAmount, 14, Toolkit.getColor("secondary1"));
            DrawingUtil.drawHatching(canvas, x + 5, y + 3, horizontalVisibleAmount - 10, 10, Toolkit.getColor("primary1"), Toolkit.getColor("primary3"));
        }
    }

    public void firstClick(Click click) {
        int area = this.adjust(click);
        switch (area) {
            case 1: {
                this.topHeader.firstClick(click);
                break;
            }
            case 2: {
                this.leftHeader.firstClick(click);
                break;
            }
            case 3: {
                this.wrappedView.firstClick(click);
                break;
            }
            case 5: {
                this.horizontalScrollBar.firstClick(click.getLocation().getX(), click.button3());
                break;
            }
            case 4: {
                this.verticalScrollBar.firstClick(click.getLocation().getY(), click.button3());
                break;
            }
        }
    }

    public Location getAbsoluteLocation() {
        Location location = super.getAbsoluteLocation();
        location.subtract(this.offset());
        return location;
    }

    public Bounds getBounds() {
        return new Bounds(this.getLocation(), this.getSize());
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = this.wrappedView.getRequiredSize(new Size(maximumSize));
        if (size.getWidth() > maximumSize.getWidth()) {
            size.extendHeight(16);
        }
        if (size.getHeight() > maximumSize.getHeight()) {
            size.extendWidth(16);
        }
        size.extend(this.left, this.top);
        size.limitSize(maximumSize);
        return size;
    }

    public Size getSize() {
        return new Size(this.size);
    }

    public View identify(Location location) {
        this.getViewManager().getSpy().addTrace(this, "mouse location within border", location);
        this.getViewManager().getSpy().addTrace(this, "non border area", this.viewportArea());
        int area = this.adjust(location);
        switch (area) {
            case 1: {
                return this.topHeader.identify(location);
            }
            case 2: {
                return this.leftHeader.identify(location);
            }
            case 3: {
                return this.wrappedView.identify(location);
            }
            case 5: {
                this.getViewManager().getSpy().addTrace(this, "over scroll bar area", this.viewportArea());
                return this.getView();
            }
            case 4: {
                this.getViewManager().getSpy().addTrace(this, "over scroll bar area", this.viewportArea());
                return this.getView();
            }
        }
        return null;
    }

    public void limitBoundsWithin(Size size) {
        super.limitBoundsWithin(size);
        this.verticalScrollBar.limit();
        this.horizontalScrollBar.limit();
    }

    public void markDamaged(Bounds bounds) {
        Offset offset = this.offset();
        bounds.translate(-offset.getDeltaX(), -offset.getDeltaY());
        bounds.translate(this.left, this.top);
        super.markDamaged(bounds);
    }

    public void mouseMoved(Location location) {
        int area = this.adjust(location);
        switch (area) {
            case 1: {
                this.topHeader.mouseMoved(location);
                break;
            }
            case 2: {
                this.leftHeader.mouseMoved(location);
                break;
            }
            case 3: {
                this.wrappedView.mouseMoved(location);
                break;
            }
        }
    }

    private Offset offset() {
        Bounds contents = this.viewportArea();
        int width = contents.getWidth();
        int x = width == 0 ? 0 : this.horizontalScrollBar.getPosition() * this.wrappedView.getRequiredSize(new Size()).getWidth() / width;
        int height = contents.getHeight();
        int y = height == 0 ? 0 : this.verticalScrollBar.getPosition() * this.wrappedView.getRequiredSize(new Size()).getHeight() / height;
        return new Offset(x, y);
    }

    protected boolean overContent(Location location) {
        return this.viewportArea().contains(location);
    }

    public void reset() {
        this.horizontalScrollBar.reset();
        this.verticalScrollBar.reset();
    }

    public void secondClick(Click click) {
        int area = this.adjust(click);
        switch (area) {
            case 1: {
                this.topHeader.secondClick(click);
                break;
            }
            case 2: {
                this.leftHeader.secondClick(click);
                break;
            }
            case 3: {
                this.wrappedView.secondClick(click);
                break;
            }
            case 5: {
                this.horizontalScrollBar.secondClick(click.getLocation().getX());
                break;
            }
            case 4: {
                this.verticalScrollBar.secondClick(click.getLocation().getY());
                break;
            }
        }
    }

    public void thirdClick(Click click) {
        int area = this.adjust(click);
        switch (area) {
            case 1: {
                this.topHeader.thirdClick(click);
                break;
            }
            case 2: {
                this.leftHeader.thirdClick(click);
                break;
            }
            case 3: {
                this.wrappedView.thirdClick(click);
                break;
            }
        }
    }

    public void setBounds(Bounds bounds) {
        this.setLocation(bounds.getLocation());
        this.setSize(bounds.getSize());
    }

    public void setMaximumSize(Size size) {
        Size wrappedSize = new Size(size);
        wrappedSize.contract(this.left, this.top);
        this.wrappedView.setMaximumSize(wrappedSize);
    }

    public void setSize(Size size) {
        this.size = new Size(size);
        Size contentSize = this.wrappedView.getRequiredSize(new Size());
        this.wrappedView.setSize(contentSize);
        int availableHeight2 = size.getHeight() - this.top;
        int contentHeight2 = contentSize.getHeight();
        this.right = availableHeight2 >= contentHeight2 ? 0 : 16;
        int availableWidth2 = size.getWidth() - this.left;
        int contentWidth2 = contentSize.getWidth();
        this.bottom = availableWidth2 >= contentWidth2 ? 0 : 16;
        Bounds viewport = this.viewportArea();
        int viewportHeight = viewport.getHeight();
        int maxContentHeight = Math.max(viewportHeight, contentSize.getHeight());
        this.verticalScrollBar.setSize(viewportHeight, maxContentHeight);
        if (this.leftHeader != null) {
            this.leftHeader.setSize(new Size(this.left, maxContentHeight));
        }
        int viewportWidth = viewport.getWidth();
        int maxContentWidth = Math.max(viewportWidth, contentSize.getWidth());
        this.horizontalScrollBar.setSize(viewportWidth, maxContentWidth);
        if (this.topHeader != null) {
            this.topHeader.setSize(new Size(maxContentWidth, this.top));
        }
    }

    public int getVerticalPosition() {
        return this.verticalScrollBar.getPosition();
    }

    public int getHorizontalPosition() {
        return this.horizontalScrollBar.getPosition();
    }

    public ViewAreaType viewAreaType(Location location) {
        int area = this.adjust(location);
        switch (area) {
            case 1: {
                return this.topHeader.viewAreaType(location);
            }
            case 2: {
                return this.leftHeader.viewAreaType(location);
            }
            case 3: {
                return this.wrappedView.viewAreaType(location);
            }
        }
        return ViewAreaType.INTERNAL;
    }

    public void viewMenuOptions(UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(new AbstractUserAction("Reset scroll border"){

            public void execute(Workspace workspace, View view, Location at) {
                ScrollBorder.this.reset();
                ScrollBorder.this.invalidateLayout();
            }
        });
    }
}

