/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.debug;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.viewer.debug.DebugOutput;

public abstract class DebugFrame
extends Frame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DebugFrame.class);
    private static Vector frames = new Vector();
    private int panel = 0;
    private TextArea field;
    private TabPane tabPane;

    public static void disposeAll() {
        int i;
        Frame[] f = new Frame[frames.size()];
        for (i = 0; i < f.length; ++i) {
            f[i] = (Frame)frames.elementAt(i);
        }
        for (i = 0; i < f.length; ++i) {
            f[i].dispose();
        }
    }

    public DebugFrame() {
        Image image;
        frames.addElement(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DebugFrame.this.closeDialog();
            }
        });
        URL url = DebugFrame.class.getResource("/images/debug-log.gif");
        if (url != null && (image = Toolkit.getDefaultToolkit().getImage(url)) != null) {
            this.setIconImage(image);
        }
        this.setLayout(new BorderLayout(7, 7));
        Panel tabPane = this.createTabPane();
        this.add(tabPane);
    }

    private Panel createTabPane() {
        this.tabPane = new TabPane();
        this.tabPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                DebugFrame.this.panel = DebugFrame.this.tabPane.select(point);
                DebugFrame.this.showDebugForPane();
            }
        });
        this.tabPane.setLayout(new BorderLayout(7, 7));
        TextArea textArea = new TextArea("", 60, 110, 0);
        textArea.setForeground(Color.black);
        textArea.setEditable(false);
        Font font = new Font("Monospaced", 0, 11);
        textArea.setFont(font);
        this.tabPane.add("Center", textArea);
        this.field = textArea;
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout());
        this.tabPane.add((Component)buttons, "South");
        Button b = new Button("Refresh");
        b.setFont(font);
        buttons.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.showDebugForPane();
            }
        });
        b = new Button("Print...");
        b.setFont(font);
        buttons.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugOutput.print("Debug " + DebugFrame.this.tabPane.getName(), DebugFrame.this.field.getText());
            }
        });
        b = new Button("Save...");
        b.setFont(font);
        buttons.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugOutput.saveToFile("Save details", "Debug " + DebugFrame.this.tabPane.getName(), DebugFrame.this.field.getText());
            }
        });
        b = new Button("Copy");
        b.setFont(font);
        buttons.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugOutput.saveToClipboard(DebugFrame.this.field.getText());
            }
        });
        b = new Button("Close");
        b.setFont(font);
        buttons.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugFrame.this.closeDialog();
            }
        });
        return this.tabPane;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.left += 10;
        insets.right += 10;
        insets.top += 10;
        insets.bottom += 10;
        return insets;
    }

    private void closeDialog() {
        this.dialogClosing();
        this.dispose();
    }

    public void dialogClosing() {
    }

    public void dispose() {
        LOG.debug((Object)"dispose...");
        this.tabPane.removeAll();
        frames.removeElement(this);
        super.dispose();
        LOG.debug((Object)"...disposed");
    }

    protected abstract DebugInfo[] getInfo();

    public void show(int x, int y) {
        this.refresh();
        this.pack();
        this.limitBounds(x, y);
        this.setVisible(true);
    }

    private void refresh() {
        DebugInfo[] infos = this.getInfo();
        DebugInfo info = infos[this.panel];
        if (info != null) {
            this.setTitle(info.debugTitle());
            DebugString str = new DebugString();
            info.debugData(str);
            this.field.setText(str.toString());
            this.field.setCaretPosition(0);
        }
    }

    public void showDebugForPane() {
        this.refresh();
    }

    private void limitBounds(int xLimit, int yLimit) {
        int y;
        Dimension screenSize = this.getToolkit().getScreenSize();
        int maxWidth = screenSize.width - 50;
        int maxHeight = screenSize.height - 50;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int x = xLimit;
        if (x + width > maxWidth && (x = 0) + width > maxWidth) {
            width = maxWidth;
        }
        if ((y = yLimit) + height > maxHeight && (y = 0) + height > maxHeight) {
            height = maxHeight;
        }
        this.setSize(width, height);
        this.setLocation(x, y);
    }

    private class TabPane
    extends Panel {
        private static final long serialVersionUID = 1L;
        private Rectangle[] tabs;
        private int panel = 0;

        private TabPane() {
        }

        public int select(Point point) {
            for (int i = 0; i < this.tabs.length; ++i) {
                if (this.tabs[i] == null || !this.tabs[i].contains(point)) continue;
                this.panel = i;
                this.repaint();
                break;
            }
            return this.panel;
        }

        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.left += 10;
            insets.right += 10;
            insets.top += 30;
            insets.bottom += 10;
            return insets;
        }

        public void paint(Graphics g) {
            DebugInfo[] info = DebugFrame.this.getInfo();
            if (info != null) {
                if (this.tabs == null) {
                    this.tabs = new Rectangle[DebugFrame.this.getInfo().length];
                }
                Dimension size = this.getSize();
                g.setColor(Color.gray);
                g.drawRect(0, 20, size.width - 1, size.height - 21);
                FontMetrics fm = g.getFontMetrics();
                int offset = 0;
                int maxWidth = info.length == 0 ? size.width : size.width / info.length - 1;
                for (int i = 0; i < info.length; ++i) {
                    String title = info[i].debugTitle();
                    title = title == null ? info[i].getClass().getName() : title;
                    int width = Math.min(maxWidth, fm.stringWidth(title) + 20);
                    this.tabs[i] = new Rectangle(offset, 0, width, 20);
                    g.setColor(Color.gray);
                    g.drawRect(offset + 0, 0, width, 20);
                    if (i == this.panel) {
                        g.setColor(Color.white);
                        g.fillRect(offset + 1, 1, width - 1, 20);
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.lightGray);
                        g.fillRect(offset + 1, 1, width - 1, 19);
                        g.setColor(Color.gray);
                    }
                    g.drawString(title, offset + 9, 15);
                    offset += width;
                }
                g.setColor(Color.white);
                g.fillRect(offset + 1, 1, size.width - offset, 19);
            }
        }
    }
}

