/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Hashtable;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.image.AwtImage;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.imageloader.TemplateImage;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;

public class ImageFactory {
    private static final String DEFAULT_IMAGE_NAME = "Default";
    private static final String DEFAULT_IMAGE_PROPERTY = "nakedobjects.viewer.dnd.default-image";
    private static ImageFactory instance;
    private static final String SEPARATOR = "_";
    private final TemplateImageLoader loader;
    private final Hashtable<String, org.nakedobjects.plugins.dndviewer.viewer.drawing.Image> templateImages = new Hashtable();

    public static ImageFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance not set up yet");
        }
        return instance;
    }

    public ImageFactory(TemplateImageLoader imageLoader) {
        this.loader = imageLoader;
        instance = this;
    }

    public org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadIcon(NakedObjectSpecification specification, int iconHeight, Color tint) {
        return this.findIcon(specification, iconHeight, null);
    }

    private org.nakedobjects.plugins.dndviewer.viewer.drawing.Image findIcon(NakedObjectSpecification specification, int iconHeight, Color tint) {
        org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadIcon = null;
        if (loadIcon == null) {
            String fullClassNameSlashes = specification.getFullName().replace(".", "/");
            loadIcon = this.loadIcon(fullClassNameSlashes, iconHeight, tint);
        }
        if (loadIcon == null) {
            String fullClassNameUnderscores = specification.getFullName().replace('.', '_');
            loadIcon = this.loadIcon(fullClassNameUnderscores, iconHeight, tint);
        }
        if (loadIcon == null) {
            String shortClassNameUnderscores = specification.getShortName().replace('.', '_');
            loadIcon = this.loadIcon(shortClassNameUnderscores, iconHeight, tint);
        }
        if (loadIcon == null) {
            loadIcon = this.findIconForSuperClass(specification, iconHeight, tint);
        }
        return loadIcon;
    }

    private org.nakedobjects.plugins.dndviewer.viewer.drawing.Image findIconForSuperClass(NakedObjectSpecification specification, int iconHeight, Color tint) {
        NakedObjectSpecification superclassSpecification = specification.superclass();
        org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadIcon = superclassSpecification == null ? null : this.findIcon(superclassSpecification, iconHeight, tint);
        return loadIcon;
    }

    public org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadIcon(String name, int height, Color tint) {
        String id = name + SEPARATOR + height + SEPARATOR + tint;
        if (this.templateImages.containsKey(id)) {
            return this.templateImages.get(id);
        }
        TemplateImage template = this.templateImage(name);
        if (template == null) {
            return null;
        }
        Image iconImage = template.getIcon(height);
        if (tint != null) {
            Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(iconImage.getSource(), new Filter()));
        }
        AwtImage icon = new AwtImage(iconImage);
        this.templateImages.put(id, icon);
        return icon;
    }

    public org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadDefaultIcon(int height, Color tint) {
        String fallbackImage = this.getConfiguration().getString(DEFAULT_IMAGE_PROPERTY, DEFAULT_IMAGE_NAME);
        org.nakedobjects.plugins.dndviewer.viewer.drawing.Image icon = this.loadIcon(fallbackImage, height, tint);
        if (icon == null) {
            icon = this.loadIcon("unknown", height, tint);
        }
        if (icon == null) {
            throw new NakedObjectException("Failed to find default icon: " + fallbackImage);
        }
        return icon;
    }

    public org.nakedobjects.plugins.dndviewer.viewer.drawing.Image loadImage(String path) {
        TemplateImage template = this.templateImage(path);
        if (template == null) {
            return null;
        }
        return new AwtImage(template.getImage());
    }

    private TemplateImage templateImage(String name) {
        TemplateImage template = this.loader.getTemplateImage(name);
        return template;
    }

    private NakedObjectConfiguration getConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }

    private static class Filter
    extends RGBImageFilter {
        private Filter() {
        }

        public int filterRGB(int x, int y, int rgb) {
            return 0xFFFFFF - rgb;
        }
    }
}

