/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.tree;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dndviewer.CollectionContent;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.NullContent;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.border.ScrollBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.SelectableViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.list.SimpleListSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.InternalTableSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.ViewResizeBorder;
import org.nakedobjects.plugins.dndviewer.viewer.view.form.InternalFormSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractCompositeView;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.BlankView;

public class MasterDetailPanel
extends AbstractCompositeView {
    private static final int MINIMUM_WIDTH = 120;
    private final ViewSpecification mainViewFormSpec;
    private final ViewSpecification mainViewListSpec;
    private final ViewSpecification mainViewTableSpec;
    private final ViewSpecification rightHandSideSpecification;

    public MasterDetailPanel(Content content, ViewSpecification specification, ViewAxis axis, ViewSpecification rightHandSideSpecification) {
        super(content, specification, axis);
        this.rightHandSideSpecification = rightHandSideSpecification;
        this.mainViewFormSpec = new InternalFormSpecification();
        this.mainViewTableSpec = new InternalTableSpecification();
        this.mainViewListSpec = new SimpleListSpecification();
    }

    protected void buildView() {
        SelectableViewAxis axis = new SelectableViewAxis(this);
        Content content = this.getContent();
        View listView = this.rightHandSideSpecification.createView(content, axis);
        listView = new ViewResizeBorder(new ScrollBorder(listView));
        listView.setParent(this.getView());
        this.addView(listView);
        BlankView blankView = new BlankView(new NullContent());
        blankView.setParent(this.getView());
        this.addView(blankView);
        if (content instanceof CollectionContent) {
            NakedObject firstElement = ((CollectionContent)((Object)content)).elements()[0];
            Content firstElementContent = Toolkit.getContentFactory().createRootContent(firstElement);
            this.setSelectedNode(firstElementContent);
        } else if (content instanceof ObjectContent) {
            this.setSelectedNode(content);
        }
    }

    protected void doLayout(Size maximumSize) {
        Size rightPanelRequiredSize;
        maximumSize.contract(this.getView().getPadding());
        View[] subviews = this.getSubviews();
        View left = subviews[0];
        View right = subviews[1];
        Size leftPanelRequiredSize = left.getRequiredSize(new Size(maximumSize));
        Size size = rightPanelRequiredSize = right == null ? new Size() : right.getRequiredSize(new Size(maximumSize));
        if (leftPanelRequiredSize.getWidth() + rightPanelRequiredSize.getWidth() > maximumSize.getWidth()) {
            int availableWidth = maximumSize.getWidth();
            int leftWidth = Math.max(120, leftPanelRequiredSize.getWidth());
            int rightWidth = rightPanelRequiredSize.getWidth();
            int totalWidth = leftWidth + rightWidth;
            int bestWidth = (int)(1.0 * (double)leftWidth / (double)totalWidth * (double)availableWidth);
            Size maximumSizeLeft = new Size(bestWidth, maximumSize.getHeight());
            leftPanelRequiredSize = left.getRequiredSize(maximumSizeLeft);
            Size maximumSizeRight = new Size(availableWidth - leftPanelRequiredSize.getWidth(), maximumSize.getHeight());
            rightPanelRequiredSize = right.getRequiredSize(maximumSizeRight);
        }
        Size combinedSize = new Size(leftPanelRequiredSize);
        combinedSize.extendWidth(rightPanelRequiredSize.getWidth());
        combinedSize.ensureHeight(rightPanelRequiredSize.getHeight());
        combinedSize.setHeight(Math.min(combinedSize.getHeight(), maximumSize.getHeight()));
        left.setSize(new Size(leftPanelRequiredSize.getWidth(), combinedSize.getHeight()));
        left.layout(new Size(new Size(leftPanelRequiredSize)));
        if (right != null) {
            right.setLocation(new Location(left.getSize().getWidth(), 0));
            rightPanelRequiredSize.setHeight(combinedSize.getHeight());
            right.setSize(rightPanelRequiredSize);
            right.layout(rightPanelRequiredSize);
        }
    }

    public Size getMaximumSize() {
        View[] subviews;
        Size total = new Size();
        for (View view : subviews = this.getSubviews()) {
            Size size = view.getSize();
            total.extendWidth(size.getWidth());
            total.ensureHeight(size.getHeight());
        }
        return total;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size rightPanelRequiredSize;
        View[] subviews = this.getSubviews();
        View left = subviews[0];
        View right = subviews[1];
        Size leftPanelRequiredSize = left.getRequiredSize(new Size(maximumSize));
        Size size = rightPanelRequiredSize = right == null ? new Size() : right.getRequiredSize(new Size(maximumSize));
        if (leftPanelRequiredSize.getWidth() + rightPanelRequiredSize.getWidth() > maximumSize.getWidth()) {
            int availableWidth = maximumSize.getWidth();
            int leftWidth = leftPanelRequiredSize.getWidth();
            int rightWidth = Math.max(120, rightPanelRequiredSize.getWidth());
            int totalWidth = leftWidth + rightWidth;
            int bestWidth = (int)(1.0 * (double)leftWidth / (double)totalWidth * (double)availableWidth);
            Size maximumSizeLeft = new Size(bestWidth, maximumSize.getHeight());
            leftPanelRequiredSize = left.getRequiredSize(maximumSizeLeft);
            Size maximumSizeRight = new Size(availableWidth - leftPanelRequiredSize.getWidth(), maximumSize.getHeight());
            rightPanelRequiredSize = right.getRequiredSize(maximumSizeRight);
        }
        Size combinedSize = new Size(leftPanelRequiredSize);
        combinedSize.extendWidth(rightPanelRequiredSize.getWidth());
        combinedSize.ensureHeight(rightPanelRequiredSize.getHeight());
        return combinedSize;
    }

    protected void showInRightPane(View view) {
        this.replaceView(this.getSubviews()[1], view);
    }

    public void setSelectedNode(View view) {
        Content content = view.getContent();
        this.setSelectedNode(content);
    }

    private void setSelectedNode(Content content) {
        NakedObject object = content.getNaked();
        NakedObjectSpecification specification = object.getSpecification();
        CollectionFacet facet = (CollectionFacet)specification.getFacet(CollectionFacet.class);
        ViewRequirement requirement = new ViewRequirement(content, 4);
        if (facet != null && facet.size(object) > 0) {
            if (this.mainViewTableSpec.canDisplay(content, requirement)) {
                this.showInRightPane(this.mainViewTableSpec.createView(content, null));
            } else if (this.mainViewListSpec.canDisplay(content, requirement)) {
                this.showInRightPane(this.mainViewListSpec.createView(content, null));
            }
        } else if (specification.isObject() && object != null && this.mainViewFormSpec.canDisplay(content, requirement)) {
            this.showInRightPane(this.mainViewFormSpec.createView(content, null));
        }
    }

    public String toString() {
        return "MasterDetailPanel" + this.getId();
    }
}

