/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.tree;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.ClosedCollectionNodeSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.ClosedObjectNodeSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.EmptyNodeSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.OpenCollectionNodeSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.tree.OpenObjectNodeSpecification;

public class TreeSpecification
implements ViewSpecification {
    private final OpenCollectionNodeSpecification openCollection;
    private final OpenObjectNodeSpecification openObject;

    public TreeSpecification() {
        ClosedObjectNodeSpecification closedObject = new ClosedObjectNodeSpecification(false);
        ClosedCollectionNodeSpecification closedCollection = new ClosedCollectionNodeSpecification();
        EmptyNodeSpecification noNode = new EmptyNodeSpecification();
        this.openCollection = new OpenCollectionNodeSpecification();
        this.openCollection.setCollectionSubNodeSpecification(noNode);
        this.openCollection.setObjectSubNodeSpecification(closedObject);
        this.openCollection.setReplacementNodeSpecification(closedCollection);
        this.openObject = new OpenObjectNodeSpecification();
        this.openObject.setCollectionSubNodeSpecification(closedCollection);
        this.openObject.setObjectSubNodeSpecification(noNode);
        this.openObject.setReplacementNodeSpecification(closedObject);
        closedObject.setReplacementNodeSpecification(this.openObject);
        closedCollection.setReplacementNodeSpecification(this.openCollection);
    }

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        return requirement.is(4) && (this.openCollection.canDisplay(content, requirement) || this.openObject.canDisplay(content, requirement));
    }

    public View createView(Content content, ViewAxis axis) {
        ViewRequirement requirement = new ViewRequirement(content, axis, 1);
        View rootNode = this.openCollection.canDisplay(content, requirement) ? this.openCollection.createView(content, axis) : this.openObject.createView(content, axis);
        return rootNode;
    }

    public String getName() {
        return "Tree";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

