/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.undo;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dndviewer.viewer.undo.Command;

public class AssociateCommand
implements Command {
    private final String description;
    private final OneToOneAssociation field;
    private final NakedObject object;
    private final NakedObject associatedObject;
    private final String name;

    public AssociateCommand(NakedObject object, NakedObject associatedObject, OneToOneAssociation field) {
        this.description = "Clear association of " + associatedObject.titleString();
        this.name = "associate " + associatedObject.titleString();
        this.object = object;
        this.associatedObject = associatedObject;
        this.field = field;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void undo() {
        this.field.clearAssociation(this.object);
    }

    public void execute() {
        this.field.setAssociation(this.object, this.associatedObject);
    }
}

