/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.calendar;

import org.nakedobjects.plugins.dndviewer.CollectionContent;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.border.ObjectBorder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.CollectionElementBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarAxis;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarBorder;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarBorderTab;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarLayout;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarTemplate;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.MonthDisplay;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.NamedCalendarBorderTab;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.WeekDisplay;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;

public class CalendarSpecification
extends AbstractCompositeViewSpecification
implements SubviewSpec {
    public CalendarSpecification() {
        this.builder = new CalendarLayout(new CollectionElementBuilder(this));
    }

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        return content instanceof CollectionContent && requirement.is(4);
    }

    protected ViewAxis axis(Content content) {
        return new CalendarAxis();
    }

    protected View decorateView(View view) {
        MonthDisplay monthDisplay = new MonthDisplay();
        WeekDisplay weekDisplay = new WeekDisplay();
        CalendarTemplate calendarTemplate = new CalendarTemplate(view, monthDisplay);
        CalendarBorderTab[] tabs = new CalendarBorderTab[]{new NamedCalendarBorderTab("Month", monthDisplay), new NamedCalendarBorderTab("Week", weekDisplay), new NamedCalendarBorderTab("Day", null)};
        CalendarBorder calendarBorder = new CalendarBorder(calendarTemplate, tabs);
        return calendarBorder;
    }

    public String getName() {
        return "Calendar";
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }

    public View createSubview(Content content, ViewAxis axis, int fieldNumber) {
        Icon icon = new Icon(content, this, axis);
        icon.setTitle(new ObjectTitleText(icon, Toolkit.getText("normal")));
        icon.setSelectedIcon(new IconGraphic((View)icon, 24));
        icon.setVertical(true);
        return new ObjectBorder(icon);
    }
}

