/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.plugins.dndviewer.BackgroundTask;
import org.nakedobjects.plugins.dndviewer.BackgroundThread;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.ClearValueOption;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.CopyValueOption;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.PasteValueOption;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public abstract class AbstractField
extends AbstractView {
    protected static final int TEXT_WIDTH = 20;
    private boolean identified;

    protected AbstractField(Content content, ViewSpecification design, ViewAxis axis) {
        super(content, design, axis);
    }

    public boolean canFocus() {
        return this.canChangeValue().isAllowed();
    }

    void clear() {
    }

    void copyToClipboard() {
    }

    public Consent canChangeValue() {
        TextParseableContent cont = (TextParseableContent)this.getContent();
        return cont.isEditable();
    }

    public void drag(InternalDrag drag) {
    }

    public void dragCancel(InternalDrag drag) {
    }

    public View dragFrom(Location location) {
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
        if (this.getState().isActive()) {
            canvas.clearBackground(this, Toolkit.getColor("identified"));
        }
        if (this.getState().isOutOfSynch()) {
            canvas.clearBackground(this, Toolkit.getColor("out-of-sync"));
        }
        if (this.getState().isInvalid()) {
            canvas.clearBackground(this, Toolkit.getColor("invalid"));
        }
        super.draw(canvas);
    }

    public void editComplete(boolean moveToNextField) {
    }

    public void entered() {
        super.entered();
        this.identified = true;
        Consent changable = this.canChangeValue();
        if (changable.isVetoed()) {
            this.getFeedbackManager().setViewDetail(changable.getReason());
        }
        this.markDamaged();
    }

    public void exited() {
        super.exited();
        this.identified = false;
        this.markDamaged();
    }

    public boolean getIdentified() {
        return this.identified;
    }

    public Padding getPadding() {
        return new Padding(0, 0, 0, 0);
    }

    public View getRoot() {
        throw new NotYetImplementedException();
    }

    String getSelectedText() {
        return "";
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public boolean indicatesForView(Location mouseLocation) {
        return false;
    }

    public void keyPressed(KeyboardAction key) {
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void contentMenuOptions(UserActionSet options) {
        options.add(new CopyValueOption(this));
        options.add(new PasteValueOption(this));
        options.add(new ClearValueOption(this));
        if (this.getView().getSpecification().isReplaceable()) {
            this.replaceOptions(Toolkit.getViewFactory().valueViews(this.getContent(), this), options);
        }
        super.contentMenuOptions(options);
        options.setColor(Toolkit.getColor("background.value-menu"));
    }

    protected final void initiateSave(final boolean moveToNextField) {
        BackgroundThread.run(this, new BackgroundTask(){

            public void execute() {
                AbstractField.this.save();
                AbstractField.this.getParent().updateView();
                AbstractField.this.invalidateLayout();
                if (moveToNextField) {
                    AbstractField.this.getFocusManager().focusNextView();
                }
            }

            public String getName() {
                return "Save field";
            }

            public String getDescription() {
                return "Saving " + AbstractField.this.getContent().windowTitle();
            }
        });
    }

    protected abstract void save();

    protected void saveValue(NakedObject value) {
        this.parseEntry(value.titleString());
    }

    protected void parseEntry(String entryText) {
        TextParseableContent content = (TextParseableContent)this.getContent();
        content.parseTextEntry(entryText);
        content.entryComplete();
    }

    void pasteFromClipboard() {
    }

    public String toString() {
        String cls = this.getClass().getName();
        NakedObject nakedObject = this.getContent().getNaked();
        return cls.substring(cls.lastIndexOf(46) + 1) + this.getId() + " [location=" + this.getLocation() + ",object=" + (nakedObject == null ? "" : nakedObject.getObject()) + "]";
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.INTERNAL;
    }

    public int getBaseline() {
        return Toolkit.defaultBaseline();
    }
}

