/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.value.BooleanValueFacet;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractFieldSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.AbstractField;

public class CheckboxField
extends AbstractField {
    private static final int size = Toolkit.getText("normal").getTextHeight();

    public CheckboxField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        Color color = this.getIdentified() ? Toolkit.getColor("secondary2") : null;
        color = this.hasFocus() ? Toolkit.getColor("identified") : color;
        int top = VPADDING;
        int left = HPADDING;
        if (color != null) {
            canvas.drawRectangle(left - 2, top - 2, size + 4, size + 4, color);
        }
        color = Toolkit.getColor("black");
        canvas.drawRectangle(left, top, size, size, color);
        if (this.isSet()) {
            Shape tick = new Shape(0, 6);
            tick.addVertex(4, 12);
            tick.addVertex(12, 0);
            tick.addVertex(4, 8);
            canvas.drawSolidShape(tick, 3, 3, color);
        }
    }

    public void firstClick(Click click) {
        this.toggle();
    }

    public void keyTyped(char keyCode) {
        if (keyCode == ' ') {
            this.toggle();
        } else {
            super.keyTyped(keyCode);
        }
    }

    private void toggle() {
        if (this.canChangeValue().isAllowed()) {
            this.initiateSave(false);
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    public Size getMaximumSize() {
        return new Size(HPADDING + size + HPADDING, VPADDING + size + VPADDING);
    }

    private boolean isSet() {
        BooleanValueFacet booleanValueFacet = (BooleanValueFacet)this.getContent().getSpecification().getFacet(BooleanValueFacet.class);
        return booleanValueFacet.isSet(this.getContent().getNaked());
    }

    protected void save() {
        BooleanValueFacet booleanValueFacet = (BooleanValueFacet)this.getContent().getSpecification().getFacet(BooleanValueFacet.class);
        NakedObject naked = this.getContent().getNaked();
        if (naked == null) {
            this.getContent().parseTextEntry("true");
        } else {
            booleanValueFacet.toggle(naked);
        }
        this.markDamaged();
        ((TextParseableContent)this.getContent()).entryComplete();
        this.getParent().invalidateContent();
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return content.isTextParseable() && content.getSpecification().getFacet(BooleanValueFacet.class) != null;
        }

        public View createView(Content content, ViewAxis axis) {
            return new CheckboxField(content, this, axis);
        }

        public String getName() {
            return "Checkbox";
        }
    }
}

