/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.ColorField;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

class ColorFieldOverlay
extends AbstractView {
    private static final int[] colors = new int[]{0xFFFFFF, 0, 0x666666, 0xCCCCCC, 153, 26316, 13311, 0x99CCFF, 0x990000, 0xFF0033, 0xCC0066, 0xFF66FF, 13056, 65331, 0x669933, 0xCCFF66};
    private static final int COLUMNS = 4;
    private static final int ROWS = 4;
    private static final int ROW_HEIGHT = 18;
    private static final int COLUMN_WIDTH = 23;
    private final ColorField field;

    public ColorFieldOverlay(ColorField field) {
        super(field.getContent(), null, null);
        this.field = field;
    }

    public Size getMaximumSize() {
        return new Size(92, 72);
    }

    public void draw(Canvas canvas) {
        canvas.drawSolidRectangle(0, 0, 91, 71, Toolkit.getColor("secondary3"));
        for (int i = 0; i < colors.length; ++i) {
            Color color = Toolkit.getColor(colors[i]);
            int y = i / 4 * 18;
            int x = i % 4 * 23;
            canvas.drawSolidRectangle(x, y, 22, 17, color);
        }
        canvas.drawRectangle(0, 0, 91, 71, Toolkit.getColor("primary2"));
    }

    public void firstClick(Click click) {
        int x = click.getLocation().getX();
        int y = click.getLocation().getY();
        int color = colors[y / 18 * 4 + x / 23];
        this.field.setColor(color);
        this.dispose();
    }
}

