/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.message;

import java.util.StringTokenizer;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.message.MessageContent;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

class DetailedMessageView
extends AbstractView {
    protected DetailedMessageView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendHeight(Toolkit.getText("title").getTextHeight());
        size.extendHeight(30);
        String message = ((MessageContent)this.getContent()).getMessage();
        size.ensureWidth(500);
        size.extendHeight(Toolkit.getText("normal").stringHeight(message, 500));
        size.extendHeight(30);
        String detail = ((MessageContent)this.getContent()).getDetail();
        StringTokenizer st = new StringTokenizer(detail, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            size.ensureWidth((line.startsWith("\t") ? 20 : 0) + Toolkit.getText("normal").stringWidth(line));
            size.extendHeight(Toolkit.getText("normal").getTextHeight());
        }
        size.extend(40, 20);
        return size;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int left = 10;
        int y = 10 + Toolkit.getText("title").getAscent();
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        String detail = ((MessageContent)this.getContent()).getDetail();
        canvas.drawText(heading, 10, y, Toolkit.getColor("black"), Toolkit.getText("title"));
        canvas.drawText(message, 10, y += Toolkit.getText("title").getTextHeight(), 500, Toolkit.getColor("black"), Toolkit.getText("normal"));
        canvas.drawText(detail, 10, y += Toolkit.getText("normal").stringHeight(message, 500), 1000, Toolkit.getColor("primary1"), Toolkit.getText("normal"));
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.VIEW;
    }
}

