/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.message;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractButtonAction;
import org.nakedobjects.plugins.dndviewer.viewer.action.CancelAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dndviewer.viewer.debug.DebugOutput;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.view.message.DetailedMessageView;
import org.nakedobjects.plugins.dndviewer.viewer.view.message.MessageContent;

public class DetailedMessageViewSpecification
implements ViewSpecification {
    public boolean canDisplay(Content content, ViewRequirement requirement) {
        return content instanceof MessageContent && ((MessageContent)content).getDetail() != null;
    }

    public String getName() {
        return "Detailed Message";
    }

    public View createView(Content content, ViewAxis axis) {
        ButtonAction[] actions = new ButtonAction[]{new AbstractButtonAction("Print..."){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.print("Print exception", DetailedMessageViewSpecification.this.extract(view));
            }
        }, new AbstractButtonAction("Save..."){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.saveToFile("Save exception", "Exception", DetailedMessageViewSpecification.this.extract(view));
            }
        }, new AbstractButtonAction("Copy"){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.saveToClipboard(DetailedMessageViewSpecification.this.extract(view));
            }
        }, new CancelAction()};
        return new ButtonBorder(actions, new DetailedMessageView(content, this, null));
    }

    private String extract(View view) {
        Content content = view.getContent();
        String message = ((MessageContent)content).getMessage();
        String heading = ((MessageContent)content).title();
        String detail = ((MessageContent)content).getDetail();
        StringBuffer text = new StringBuffer();
        text.append(heading);
        text.append("\n\n");
        text.append(message);
        text.append("\n\n");
        text.append(detail);
        text.append("\n\n");
        return text.toString();
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

