/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.message;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dndviewer.viewer.view.message.MessageContent;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

class MessageDialogView
extends AbstractView {
    private static final int MAX_TEXT_WIDTH = 400;
    private static final int LEFT = 20;
    private static final int RIGHT = 20;
    private static final int TOP = 15;
    private static final int PADDING = 10;
    private Image errorIcon;
    private FocusManager focusManager;

    protected MessageDialogView(MessageContent content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        String iconName = ((MessageContent)this.getContent()).getIconName();
        this.errorIcon = ImageFactory.getInstance().loadIcon(iconName, 32, null);
        if (this.errorIcon == null) {
            this.errorIcon = ImageFactory.getInstance().loadDefaultIcon(32, null);
        }
    }

    public Size getMaximumSize() {
        Size size = new Size();
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        size.ensureHeight(this.errorIcon.getHeight());
        size.extendWidth(Toolkit.getText("normal").stringWidth(message, 400));
        int textHeight = Toolkit.getText("title").getLineHeight();
        size.ensureHeight(textHeight += Toolkit.getText("normal").stringHeight(message, 400));
        size.ensureWidth(Toolkit.getText("title").stringWidth(heading));
        size.extendWidth(this.errorIcon.getWidth());
        size.extendWidth(10);
        size.extend(40, 30);
        return size;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        canvas.clearBackground(this, Toolkit.getColor("white"));
        canvas.drawImage(this.errorIcon, 20, 15);
        int x = 20 + this.errorIcon.getWidth() + 10;
        int y = 18 + Toolkit.getText("normal").getAscent();
        if (!heading.equals("")) {
            canvas.drawText(heading, x, y, Toolkit.getColor("black"), Toolkit.getText("title"));
            y += Toolkit.getText("title").getLineHeight();
        }
        canvas.drawText(message, x, y, 400, Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.VIEW;
    }

    public FocusManager getFocusManager() {
        return this.focusManager == null ? super.getFocusManager() : this.focusManager;
    }

    public void setFocusManager(FocusManager focusManager) {
        this.focusManager = focusManager;
    }
}

