/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.simple;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.AwtColor;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.ObjectView;

public abstract class AbstractCompositeView
extends ObjectView {
    private static final Logger LOG = Logger.getLogger(AbstractCompositeView.class);
    private int buildCount = 0;
    private boolean buildInvalid = true;
    private boolean canDragView = true;
    private int layoutCount = 0;
    private boolean layoutInvalid = true;
    protected Vector<View> views = new Vector();
    private FocusManager focusManager;

    public AbstractCompositeView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void refresh() {
        View[] views = this.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            views[i].refresh();
        }
    }

    public void addView(View view) {
        this.add(this.views, view);
    }

    protected void add(Vector views, View view) {
        LOG.debug((Object)("adding " + view + " to " + this));
        views.addElement(view);
        this.getViewManager().addToNotificationList(view);
        view.setParent(this.getView());
        this.invalidateLayout();
    }

    public boolean canDragView() {
        return this.canDragView;
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendln();
    }

    public void debugStructure(DebugString b) {
        b.appendln("Built", (Object)((this.buildInvalid ? "invalid, " : "") + this.buildCount + " builds"));
        b.appendln("Laid out", (Object)((this.layoutInvalid ? "invalid, " : "") + this.layoutCount + " layouts"));
        super.debugStructure(b);
    }

    public void dispose() {
        View[] views = this.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            views[i].dispose();
        }
        super.dispose();
    }

    public void draw(Canvas canvas) {
        View[] views = this.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View subview = views[i];
            Bounds bounds = subview.getBounds();
            if (Toolkit.debug) {
                LOG.debug((Object)("compare: " + bounds + "  " + canvas));
            }
            if (!canvas.overlaps(bounds)) continue;
            Canvas subCanvas = canvas.createSubcanvas(bounds.getX(), bounds.getY(), bounds.getWidth() - 0, bounds.getSize().getHeight());
            if (Toolkit.debug) {
                LOG.debug((Object)("-- repainting " + subview));
                LOG.debug((Object)("subcanvas " + subCanvas));
            }
            subview.draw(subCanvas);
            if (!Toolkit.debug) continue;
            canvas.drawRectangle(subview.getBounds().getX(), subview.getBounds().getY(), subview.getBounds().getWidth() - 1, subview.getBounds().getHeight() - 1, AwtColor.DEBUG_BORDER_BOUNDS);
        }
    }

    public int getBaseline() {
        View[] e = this.getSubviews();
        if (e.length == 0) {
            return 14;
        }
        View subview = e[0];
        return subview.getBaseline();
    }

    public FocusManager getFocusManager() {
        return this.focusManager == null ? super.getFocusManager() : this.focusManager;
    }

    public abstract Size getMaximumSize();

    public View[] getSubviews() {
        if (this.buildInvalid) {
            this.getFeedbackManager().setBusy(this, null);
            ++this.buildCount;
            this.buildInvalid = false;
            this.buildView();
            this.getFeedbackManager().clearBusy(this);
        }
        return this.subviews();
    }

    protected abstract void buildView();

    protected View[] subviews() {
        Object[] v = new View[this.views.size()];
        this.views.copyInto(v);
        return v;
    }

    public void invalidateContent() {
        this.buildInvalid = true;
        this.invalidateLayout();
    }

    public void invalidateLayout() {
        this.layoutInvalid = true;
        super.invalidateLayout();
    }

    public void layout(Size maximumSize) {
        if (this.layoutInvalid) {
            this.getFeedbackManager().setBusy(this, null);
            ++this.layoutCount;
            this.layoutInvalid = false;
            this.markDamaged();
            this.doLayout(maximumSize);
            this.markDamaged();
            this.getFeedbackManager().clearBusy(this);
        }
    }

    protected abstract void doLayout(Size var1);

    protected boolean isLayoutInvalid() {
        return this.layoutInvalid;
    }

    public View subviewFor(Location location) {
        Location l = new Location(location);
        Padding padding = this.getPadding();
        l.subtract(padding.getLeft(), padding.getTop());
        View[] views = this.getSubviews();
        for (int i = views.length - 1; i >= 0; --i) {
            if (!views[i].getBounds().contains(l)) continue;
            return views[i];
        }
        return null;
    }

    public View pickupView(Location location) {
        return this.canDragView ? super.pickupView(location) : null;
    }

    public void removeView(View view) {
        if (!this.views.contains(view)) {
            throw new NakedObjectException(view + "\n    not in " + this.getView());
        }
        LOG.debug((Object)("removing " + view + " from " + this));
        this.views.removeElement(view);
        this.getViewManager().removeFromNotificationList(view);
        this.markDamaged();
        this.invalidateLayout();
    }

    public void replaceView(View toReplace, View replacement) {
        for (int i = 0; i < this.views.size(); ++i) {
            if (this.views.elementAt(i) != toReplace) continue;
            replacement.setParent(this.getView());
            replacement.setLocation(toReplace.getLocation());
            this.views.insertElementAt(replacement, i);
            this.invalidateLayout();
            toReplace.dispose();
            this.getViewManager().addToNotificationList(replacement);
            return;
        }
        throw new NakedObjectException(toReplace + " not found to replace");
    }

    public void setCanDragView(boolean canDragView) {
        this.canDragView = canDragView;
    }

    public void setFocusManager(FocusManager focusManager) {
        this.focusManager = focusManager;
    }

    public String toString() {
        ToString to = new ToString((Object)this, this.getId());
        to.append("type", this.getSpecification().getName());
        return to.toString();
    }

    public void update(NakedObject object) {
        LOG.debug((Object)("update notify on " + this));
        this.invalidateContent();
    }

    public ViewAreaType viewAreaType(Location location) {
        View subview = this.subviewFor(location);
        if (subview == null) {
            return ViewAreaType.VIEW;
        }
        location.subtract(subview.getLocation());
        return subview.viewAreaType(location);
    }
}

