/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.simple;

import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public class FieldErrorView
extends AbstractView {
    private final String error;

    public FieldErrorView(String errorMessage) {
        super(null, null, null);
        this.error = errorMessage;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        canvas.drawSolidRectangle(0, 0, size.getWidth() - 1, size.getHeight() - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(0, 0, size.getWidth() - 1, size.getHeight() - 1, Toolkit.getColor("black"));
        canvas.drawText(this.error, 14, 20, Toolkit.getColor("invalid"), Toolkit.getText("normal"));
    }

    public int getBaseline() {
        return 20;
    }

    public Size getMaximumSize() {
        return new Size(250, 30);
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return true;
        }

        public View createView(Content content, ViewAxis axis) {
            throw new NotYetImplementedException();
        }

        public String getName() {
            return "Field Error";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }
    }
}

