/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.specification;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.CloseViewOption;
import org.nakedobjects.plugins.dndviewer.viewer.content.OptionFactory;
import org.nakedobjects.plugins.dndviewer.viewer.content.PerspectiveContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ServiceObject;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;

public class ServiceIcon
extends Icon {
    private static final int ICON_SIZE;
    private static final int LARGE_ICON_SIZE = 34;
    private static final String LARGE_ICON_SIZE_PROPERTY;

    public ServiceIcon(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        this.setTitle(new ObjectTitleText(this, Toolkit.getText("large-icon")));
        this.setSelectedIcon(new IconGraphic((View)this, ICON_SIZE));
        this.setVertical(true);
    }

    public void contentMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.content-menu"));
        OptionFactory.addObjectMenuOptions(this.getContent().getNaked(), options);
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.view-menu"));
        options.add(new CloseViewOption(){

            public void execute(Workspace workspace, View view, Location at) {
                PerspectiveContent parent = (PerspectiveContent)view.getParent().getContent();
                PerspectiveEntry perspective = parent.getPerspective();
                ServiceObject serviceContent = (ServiceObject)view.getContent();
                NakedObject element = serviceContent.getObject();
                perspective.removeFromServices((Object)element);
                super.execute(workspace, view, at);
            }
        });
    }

    public Drag dragStart(DragStart drag) {
        View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
        return new ContentDrag(this, drag.getLocation(), dragOverlay);
    }

    static {
        LARGE_ICON_SIZE_PROPERTY = "nakedobjects.viewer.dnd.large-icon-size";
        ICON_SIZE = NakedObjectsContext.getConfiguration().getInteger(LARGE_ICON_SIZE_PROPERTY, 34);
    }
}

