package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.ColorsAndFonts;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;


public class Button extends AbstractControlView {
    private static final int TEXT_PADDING = 12;
    private final int buttonHeight;
    private boolean over;
    private boolean pressed;

    public Button(final ButtonAction action, final View target) {
        super(action, target);
        this.buttonHeight = 4 + Toolkit.getText(ColorsAndFonts.TEXT_CONTROL).getTextHeight() + 4;
    }

    @Override
    public boolean containsFocus() {
        return hasFocus();
    }

    @Override
    public void draw(final Canvas canvas) {
        final int x = 0;
        final int y = 0;

        final View target = getParent();
        final String text = action.getName(target);
        boolean vetoed = action.disabled(target).isVetoed();
        final Color color = vetoed ? Toolkit.getColor(ColorsAndFonts.COLOR_MENU_DISABLED) : Toolkit.getColor(ColorsAndFonts.COLOR_BLACK);
        final Color border = vetoed ? Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY3) : Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY2);
        final Text style = Toolkit.getText(ColorsAndFonts.TEXT_CONTROL);
        final int buttonWidth = TEXT_PADDING + style.stringWidth(text) + TEXT_PADDING;
        canvas.clearBackground(this, Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY3));
        canvas.drawRectangle(x, y, buttonWidth, buttonHeight, over & !vetoed ? Toolkit.getColor(ColorsAndFonts.COLOR_PRIMARY1) : Toolkit
                .getColor(ColorsAndFonts.COLOR_BLACK));
        canvas.draw3DRectangle(x + 1, y + 1, buttonWidth - 2, buttonHeight - 2, border, !pressed);
        canvas.draw3DRectangle(x + 2, y + 2, buttonWidth - 4, buttonHeight - 4, border, !pressed);
        if (((ButtonAction) action).isDefault()) {
            canvas.drawRectangle(x + 3, y + 3, buttonWidth - 6, buttonHeight - 6, border);
        }
        if (hasFocus()) {
            canvas.drawRectangle(x + 3, y + 3, buttonWidth - 6, buttonHeight - 6, Toolkit.getColor(ColorsAndFonts.COLOR_WHITE));
        }
        canvas.drawText(text, x + TEXT_PADDING, y + buttonHeight / 2 + style.getMidPoint(), color, style);
    }

    @Override
    public void entered() {
        over = true;
        pressed = false;
        markDamaged();
        super.entered();
    }

    @Override
    public void exited() {
        over = false;
        pressed = false;
        markDamaged();
        super.exited();
    }

    public Size getMaximumSize() {
        final String text = action.getName(getView());
        final int buttonWidth = TEXT_PADDING + Toolkit.getText(ColorsAndFonts.TEXT_CONTROL).stringWidth(text) + TEXT_PADDING;
        return new Size(buttonWidth, buttonHeight);
    }

    @Override
    public void mouseDown(final Click click) {
        final View target = getParent();
        boolean vetoed = action.disabled(target).isVetoed();
        if (!vetoed) {
            pressed = true;
            markDamaged();
        }
    }

    @Override
    public void mouseUp(final Click click) {
        final View target = getParent();
        boolean vetoed = action.disabled(target).isVetoed();
        if (!vetoed) {
            pressed = false;
            markDamaged();
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
