package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.ColorsAndFonts;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractViewDecorator;
import org.nakedobjects.plugins.dndviewer.viewer.border.ObjectBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.ObjectTitleText;


class IconOpenAction extends AbstractViewDecorator {
    protected IconOpenAction(final View wrappedView) {
        super(wrappedView);
    }

    @Override
    public void viewMenuOptions(final UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(new AbstractUserAction("Close") {
            @Override
            public void execute(final Workspace workspace, final View view, final Location at) {
                getView().dispose();
                // getWorkspace().removeObject((NakedObject) view.getContent().getNaked());
            }
        });
    }

    private void openIcon() {
        getWorkspace().addWindowFor(getContent().getNaked(), getLocation());
    }

    @Override
    public void secondClick(final Click click) {
        openIcon();
    }
}

public class RootIconSpecification extends IconSpecification {
    @Override
    public View createView(final Content content, final ViewAxis axis) {
        final Icon icon = new Icon(content, this, axis);
        final Text style = Toolkit.getText(ColorsAndFonts.TEXT_NORMAL);
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        return new ObjectBorder(new IconOpenAction(icon));
    }
    
    public boolean isReplaceable() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
