package org.nakedobjects.plugins.dndviewer.viewer.table;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;


public class TableRowSpecification extends AbstractCompositeViewSpecification {
    public TableRowSpecification() {
        builder = new TableCellBuilder();
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content.isObject();
    }

    @Override
    protected View decorateView(View view) {
        return new TableRowBorder(view);
    }

    public String getName() {
        return "Table Row";
    }

    @Override
    public boolean isReplaceable() {
        return false;
    }

    @Override
    public boolean isSubView() {
        return true;
    }
}
// Copyright (c) Naked Objects Group Ltd.
