package org.nakedobjects.plugins.dndviewer.viewer.view.extendedform;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.StackLayout;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.form.InternalFormSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.CompositeViewBuilder;
import org.nakedobjects.runtime.context.NakedObjectsContext;


public class ExtendedFormSpecification extends AbstractCompositeViewSpecification {

    public ExtendedFormSpecification() {
        builder = new StackLayout(new MyBuilder());
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        if (requirement.is(ViewRequirement.CLOSED)) {
            return false;
        } else {
            int collections = 0;
            if (content instanceof ObjectContent) {
                final NakedObject object = content.getNaked();
                final NakedObjectAssociation[] fields = object.getSpecification().getAssociations(
                        NakedObjectAssociationFilters.dynamicallyVisible(NakedObjectsContext.getAuthenticationSession(), object));
                for (int i = 0; i < fields.length; i++) {
                    if (fields[i].isOneToManyAssociation()) {
                        collections++;
                    }
                }
            }
            return collections == 1;
        }
    }

    public String getName() {
        return "Combined Form";
    }

}

class MyBuilder extends AbstractViewBuilder {

    @Override
    public void build(final View view) {
        final Content content = view.getContent();

        final View form = new InternalFormSpecification().createView(content, null);
        view.addView(form);

        /*
         * NakedObject object = ((ObjectContent) content).getObject(); NakedObjectAssociation[] fields =
         * object.getSpecification().getProperties(DynamicFilters.dynamicallyVisible(object)); for (int i = 0;
         * i < fields.length; i++) { if (fields[i].isCollection()) { } }
         */
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReplaceable() {
        return false;
    }

    @Override
    public Size getRequiredSize(final View view) {
        return super.getRequiredSize(view);
    }

    public View createCompositeView(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        return new CompositeViewBuilder(content, specification, axis);
    }
}

// Copyright (c) Naked Objects Group Ltd.
