package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.ConsentAbstract;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;


public class RevertFieldOption extends AbstractUserAction {
    private final TextField field;

    public RevertFieldOption(final TextField field) {
        super("Revert");
        this.field = field;
    }

    @Override
    public String getDescription(final View view) {
        return "Revert the field to it original state";
    }

    @Override
    public Consent disabled(final View view) {
        return ConsentAbstract.allow(field.hasInvalidEntry());
    }

    @Override
    public void execute(final Workspace workspace, final View view, final Location at) {
        field.revertInvalidEntry();
    }

}

// Copyright (c) Naked Objects Group Ltd.
