/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer;

import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class ContentDrag
extends Drag {
    private final View dragView;
    private Location location;
    private View previousTarget;
    private final Content sourceContent;
    private View target;
    private final Workspace workspace;
    private final Location offset;
    private final View source;

    public ContentDrag(View source, Location offset, View dragView) {
        if (dragView == null) {
            throw new NullPointerException();
        }
        this.workspace = source.getWorkspace();
        this.sourceContent = source.getContent();
        this.dragView = dragView;
        this.offset = offset;
        this.source = source.getView();
    }

    public void cancel(Viewer viewer) {
        if (this.target != null) {
            this.target.dragOut(this);
        }
        viewer.clearAction();
    }

    public void drag(View target, Location location, int mods) {
        this.location = location;
        this.target = target;
        this.mods = mods;
        this.moveDragView();
        this.crossBoundary(target);
        target.drag(this);
    }

    private void crossBoundary(View target) {
        if (target != this.previousTarget) {
            if (this.previousTarget != null) {
                this.previousTarget.dragOut(this);
                this.previousTarget = null;
            }
            target.dragIn(this);
            this.previousTarget = target;
        }
    }

    private void moveDragView() {
        if (this.dragView != null) {
            this.dragView.markDamaged();
            Location newLocation = new Location(this.location);
            newLocation.subtract(this.offset);
            this.dragView.setLocation(newLocation);
            this.dragView.limitBoundsWithin(this.workspace.getSize());
            this.dragView.markDamaged();
        }
    }

    public void end(Viewer viewer) {
        viewer.getSpy().addAction("drop on " + this.target);
        this.target.drop(this);
        viewer.clearAction();
    }

    public View getOverlay() {
        return this.dragView;
    }

    public View getSource() {
        return this.source;
    }

    public Content getSourceContent() {
        return this.sourceContent;
    }

    public Location getTargetLocation() {
        Location location = new Location(this.location);
        location.subtract(this.target.getAbsoluteLocation());
        return location;
    }

    public Location getOffset() {
        return this.offset;
    }

    public View getTargetView() {
        return this.target;
    }

    public String toString() {
        return "ContentDrag [" + super.toString() + "]";
    }

    public void subtract(int left, int top) {
    }
}

