/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer;

import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;

public class SimpleInternalDrag
extends InternalDrag {
    private final Location location;
    private final Location offset;
    private final View view;

    public SimpleInternalDrag(View view, Location location) {
        this.view = view;
        this.location = new Location(location);
        this.offset = view.getAbsoluteLocation();
        Padding targetPadding = view.getPadding();
        Padding containerPadding = view.getView().getPadding();
        this.offset.add(containerPadding.getLeft() - targetPadding.getLeft(), containerPadding.getTop() - targetPadding.getTop());
        this.location.subtract(this.offset);
    }

    public SimpleInternalDrag(View view, Offset off) {
        this.view = view;
        this.location = new Location();
        this.offset = new Location(off.getDeltaX(), off.getDeltaY());
        Padding targetPadding = view.getPadding();
        Padding containerPadding = view.getView().getPadding();
        this.offset.add(containerPadding.getLeft() - targetPadding.getLeft(), containerPadding.getTop() - targetPadding.getTop());
        this.location.subtract(this.offset);
    }

    public void cancel(Viewer viewer) {
        this.view.dragCancel(this);
    }

    public void drag(View target, Location location, int mods) {
        this.location.setX(location.getX());
        this.location.setY(location.getY());
        this.location.subtract(this.offset);
        this.view.drag(this);
    }

    public void end(Viewer viewer) {
        this.view.dragTo(this);
    }

    public Location getLocation() {
        return new Location(this.location);
    }

    public View getOverlay() {
        return null;
    }

    public String toString() {
        ToString s = new ToString((Object)this, super.toString());
        s.append("location", (Object)this.location);
        s.append("relative", (Object)this.getLocation());
        return s.toString();
    }
}

