/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer;

import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.plugins.dndviewer.MenuOptions;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.ShutdownListener;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.help.AboutView;

public class ApplicationOptions
implements MenuOptions {
    private final ShutdownListener listener;

    public ApplicationOptions(ShutdownListener listener) {
        this.listener = listener;
    }

    public void menuOptions(UserActionSet options) {
        options.add(new AbstractUserAction("About..."){

            public void execute(Workspace workspace, View view, Location at) {
                AboutView dialogView = new AboutView();
                Size windowSize = dialogView.getRequiredSize(new Size());
                Size workspaceSize = workspace.getSize();
                int x = workspaceSize.getWidth() / 2 - windowSize.getWidth() / 2;
                int y = workspaceSize.getHeight() / 2 - windowSize.getHeight() / 2;
                workspace.addDialog(dialogView);
                dialogView.setLocation(new Location(x, y));
            }
        });
        options.add(new AbstractUserAction("Log out"){

            public Consent disabled(View view) {
                boolean runningAsExploration = view.getViewManager().isRunningAsExploration();
                if (runningAsExploration) {
                    return new Veto("Can't log out in exploration mode");
                }
                return Allow.DEFAULT;
            }

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationOptions.this.listener.logOut();
            }
        });
        options.add(new AbstractUserAction("Quit"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationOptions.this.listener.quit();
            }
        });
    }
}

