/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.MenuOptions;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.OverlayDebugFrame;
import org.nakedobjects.plugins.dndviewer.viewer.XViewer;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.debug.InfoDebugFrame;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.internal.monitor.SystemPrinter;

public class DebugOptions
implements MenuOptions {
    private final XViewer viewer;

    public DebugOptions(XViewer viewer) {
        this.viewer = viewer;
    }

    public void menuOptions(UserActionSet options) {
        String showExplorationMenu = "Always show exploration menu " + (this.viewer.showExplorationMenuByDefault ? "off" : "on");
        options.add(new AbstractUserAction(showExplorationMenu, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                ((DebugOptions)DebugOptions.this).viewer.showExplorationMenuByDefault = !((DebugOptions)DebugOptions.this).viewer.showExplorationMenuByDefault;
                view.markDamaged();
            }
        });
        String repaint = "Show painting area  " + (this.viewer.showRepaintArea ? "off" : "on");
        options.add(new AbstractUserAction(repaint, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                ((DebugOptions)DebugOptions.this).viewer.showRepaintArea = !((DebugOptions)DebugOptions.this).viewer.showRepaintArea;
                view.markDamaged();
            }
        });
        String debug = "Debug graphics " + (Toolkit.debug ? "off" : "on");
        options.add(new AbstractUserAction(debug, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                Toolkit.debug = !Toolkit.debug;
                view.markDamaged();
            }
        });
        String action = this.viewer.isShowingMouseSpy() ? "Hide" : "Show";
        options.add(new AbstractUserAction(action + " mouse spy", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOptions.this.viewer.setShowMouseSpy(!DebugOptions.this.viewer.isShowingMouseSpy());
            }
        });
        options.add(new AbstractUserAction("Diagnostics...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                f.setInfo(new DebugInfo(){

                    public void debugData(DebugString debug) {
                        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
                        PrintStream out = new PrintStream(out2);
                        new SystemPrinter(out).printDiagnostics();
                        debug.append((Object)out2.toString());
                    }

                    public String debugTitle() {
                        return "Diagnostics";
                    }
                });
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug system...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                DebugInfo[] contextInfo = NakedObjectsContext.debugSystem();
                f.setInfo(contextInfo);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug session...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                DebugInfo[] contextInfo = NakedObjectsContext.debugSession();
                f.setInfo(contextInfo);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug viewer...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                f.setInfo(new DebugInfo[]{Toolkit.getViewFactory(), ((DebugOptions)DebugOptions.this).viewer.updateNotifier});
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug overlay...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                OverlayDebugFrame f = new OverlayDebugFrame(DebugOptions.this.viewer);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
    }
}

