/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.NullContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.basic.PopupMenuContainer;
import org.nakedobjects.plugins.dndviewer.viewer.content.AbstractContent;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.focus.SubviewFocusManager;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public class PopupMenu
extends AbstractView {
    private static final Logger LOG = Logger.getLogger(PopupMenu.class);
    private Color backgroundColor;
    private View forView;
    private Item[] items = new Item[0];
    private int optionIdentified;
    private final FocusManager simpleFocusManager;

    public PopupMenu(PopupMenuContainer parent) {
        super(new NullContent(), new PopupSpecification(), null);
        this.setContent(new PopupContent());
        this.setParent(parent);
        this.simpleFocusManager = new SubviewFocusManager(this);
    }

    private void addItems(View target, UserAction[] options, int len, Vector list, NakedObjectActionType type) {
        int initialSize = list.size();
        for (int i = 0; i < len; ++i) {
            if (options[i].getType() != type) continue;
            if (initialSize > 0 && list.size() == initialSize) {
                list.addElement(Item.createDivider());
            }
            list.addElement(Item.createOption(options[i], null, target, this.getLocation()));
        }
    }

    protected Color backgroundColor() {
        return this.backgroundColor;
    }

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return true;
    }

    protected Color disabledColor() {
        return Toolkit.getColor("color.menu.disabled");
    }

    public void draw(Canvas canvas) {
        Size coreSize = this.getSize();
        int width = coreSize.getWidth();
        int height = coreSize.getHeight();
        canvas.drawSolidRectangle(0, 0, width, height, this.backgroundColor);
        canvas.draw3DRectangle(0, 0, width, height, this.backgroundColor, true);
        int itemHeight = this.style().getLineHeight() + VPADDING;
        int baseLine = this.style().getAscent() + this.getPadding().getTop() + 1;
        int left = this.getPadding().getLeft();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].isBlank) {
                int y = baseLine - this.style().getAscent() / 2;
                canvas.drawLine(1, y, width - 2, y, this.backgroundColor.brighter());
                canvas.drawLine(1, y - 1, width - 2, y - 1, this.backgroundColor.darker());
            } else {
                Color color;
                if (this.items[i].isDisabled || this.items[i].action == null) {
                    color = this.disabledColor();
                } else if (this.getOption() == i) {
                    int top = this.getPadding().getTop() + i * itemHeight;
                    int depth = this.style().getLineHeight() + 2;
                    canvas.drawSolidRectangle(2, top, width - 4, depth, this.backgroundColor.darker());
                    canvas.draw3DRectangle(2, top, width - 4, depth + 1, this.backgroundColor.brighter(), false);
                    color = this.reversedColor();
                } else {
                    color = this.normalColor();
                }
                canvas.drawText(this.items[i].name, left, baseLine, color, this.style());
                if (this.items[i].action instanceof UserActionSet) {
                    Shape arrow = new Shape(0, 0);
                    arrow.extendsLine(4, 4);
                    arrow.extendsLine(-4, 4);
                    canvas.drawSolidShape(arrow, width - 10, baseLine - 8, color);
                }
            }
            baseLine += itemHeight;
        }
    }

    public void firstClick(Click click) {
        if (click.button1() || click.button3()) {
            this.mouseMoved(click.getLocation());
            this.invoke();
        }
    }

    public void focusLost() {
    }

    public void focusReceived() {
    }

    public FocusManager getFocusManager() {
        return this.simpleFocusManager;
    }

    public Size getMaximumSize() {
        Size size = new Size();
        for (int i = 0; i < this.items.length; ++i) {
            int itemWidth = this.items[i].isBlank ? 0 : this.style().stringWidth(this.items[i].name);
            size.ensureWidth(itemWidth);
            size.extendHeight(this.style().getLineHeight() + VPADDING);
        }
        size.extend(this.getPadding());
        size.extendWidth(HPADDING * 2);
        return size;
    }

    public int getOption() {
        return this.optionIdentified;
    }

    public int getOptionPostion() {
        int itemHeight = this.style().getLineHeight() + VPADDING;
        return itemHeight * this.getOption();
    }

    public int getOptionCount() {
        return this.items.length;
    }

    public Padding getPadding() {
        Padding in = super.getPadding();
        in.extendTop(VPADDING);
        in.extendBottom(VPADDING);
        in.extendLeft(HPADDING + 5);
        in.extendRight(HPADDING + 5);
        return in;
    }

    public Workspace getWorkspace() {
        return this.forView.getWorkspace();
    }

    public boolean hasFocus() {
        return false;
    }

    private void invoke() {
        int option = this.getOption();
        Item item = this.items[option];
        if (item.isBlank || item.action == null || item.action.disabled(this.forView).isVetoed()) {
            return;
        }
        if (item.action instanceof UserActionSet) {
            UserAction[] menuOptions = ((UserActionSet)item.action).getMenuOptions();
            ((PopupMenuContainer)this.getParent()).openSubmenu(menuOptions);
        } else {
            Workspace workspace = this.getWorkspace();
            Location location = new Location(this.getAbsoluteLocation());
            location.subtract(workspace.getView().getAbsoluteLocation());
            Padding padding = workspace.getView().getPadding();
            location.move(-padding.getLeft(), -padding.getTop());
            location.move(30, 0);
            this.getParent().dispose();
            LOG.debug((Object)("execute " + item.name + " on " + this.forView + " in " + workspace));
            item.action.execute(workspace, this.forView, location);
        }
    }

    public void keyPressed(KeyboardAction key) {
        block5: {
            int keyCode;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            keyCode = key.getKeyCode();
                            if (keyCode != 27) break block6;
                            if (this.getParent() == null) {
                                this.dispose();
                            }
                            key.consume();
                            break block5;
                        }
                        if (keyCode != 10) break block7;
                        key.consume();
                        this.invoke();
                        break block5;
                    }
                    if (keyCode != 39 || !(this.items[this.getOption()].action instanceof UserActionSet)) break block8;
                    key.consume();
                    this.invoke();
                    break block5;
                }
                if (keyCode != 38) break block9;
                key.consume();
                if (this.optionIdentified == 0) {
                    this.optionIdentified = this.items.length;
                }
                for (int i = this.optionIdentified - 1; i >= 0; --i) {
                    if (this.items[i].isBlank || this.items[i].isDisabled) continue;
                    this.setOption(i);
                    break block5;
                }
                break block5;
            }
            if (keyCode != 40) break block5;
            key.consume();
            if (this.optionIdentified == this.items.length - 1) {
                this.optionIdentified = -1;
            }
            for (int i = this.optionIdentified + 1; i < this.items.length; ++i) {
                if (this.items[i].isBlank || this.items[i].isDisabled) continue;
                this.setOption(i);
                break;
            }
        }
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public View makeView(NakedObject object, NakedObjectAssociation field) throws CloneNotSupportedException {
        throw new RuntimeException();
    }

    public void markDamaged() {
        if (this.getParent() == null) {
            super.markDamaged();
        } else {
            this.getParent().markDamaged();
        }
    }

    public void mouseMoved(Location at) {
        int option = (at.getY() - this.getPadding().getTop()) / (this.style().getLineHeight() + VPADDING);
        option = Math.max(option, 0);
        if ((option = Math.min(option, this.items.length - 1)) >= 0 && this.optionIdentified != option) {
            this.setOption(option);
            this.markDamaged();
        }
    }

    protected Color normalColor() {
        return Toolkit.getColor("color.menu.normal");
    }

    protected Color reversedColor() {
        return Toolkit.getColor("color.menu.reversed");
    }

    public void setOption(int option) {
        if (option != this.optionIdentified) {
            this.optionIdentified = option;
            this.markDamaged();
            this.updateFeedback();
        }
    }

    private void updateFeedback() {
        Item item = this.items[this.optionIdentified];
        if (item.isBlank) {
            this.getFeedbackManager().clearAction();
        } else if (this.isEmpty(item.reasonDisabled)) {
            this.getFeedbackManager().setAction(item.description == null ? "" : item.description);
        } else {
            this.getFeedbackManager().setAction(item.reasonDisabled);
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    void show(View target, UserAction[] options, Color color) {
        this.forView = target;
        this.optionIdentified = 0;
        this.backgroundColor = color;
        int len = options.length;
        if (len == 0) {
            this.items = new Item[]{Item.createNoOption()};
        } else {
            Vector list = new Vector();
            this.addItems(target, options, len, list, UserAction.USER);
            this.addItems(target, options, len, list, UserAction.EXPLORATION);
            this.addItems(target, options, len, list, UserAction.DEBUG);
            this.items = new Item[list.size()];
            list.copyInto(this.items);
        }
        this.updateFeedback();
    }

    protected Text style() {
        return Toolkit.getText("text.menu");
    }

    public String toString() {
        return "PopupMenu [location=" + this.getLocation() + ",item=" + this.optionIdentified + ",itemCount=" + (this.items == null ? 0 : this.items.length) + "]";
    }

    protected boolean transparentBackground() {
        return false;
    }

    private static class PopupSpecification
    implements ViewSpecification {
        private PopupSpecification() {
        }

        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return false;
        }

        public View createView(Content content, ViewAxis axis) {
            return null;
        }

        public String getName() {
            return "Popup Menu";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    private class PopupContent
    extends AbstractContent {
        public Consent canDrop(Content sourceContent) {
            return Veto.DEFAULT;
        }

        public void debugDetails(DebugString debug) {
        }

        public NakedObject drop(Content sourceContent) {
            return null;
        }

        public String getDescription() {
            int optionNo = PopupMenu.this.getOption();
            return ((PopupMenu)PopupMenu.this).items[optionNo].description;
        }

        public String getHelp() {
            int optionNo = PopupMenu.this.getOption();
            return PopupMenu.this.items[optionNo].getHelp();
        }

        public String getIconName() {
            return null;
        }

        public Image getIconPicture(int iconHeight) {
            return null;
        }

        public String getId() {
            return null;
        }

        public NakedObject getNaked() {
            return null;
        }

        public boolean isOptionEnabled() {
            return false;
        }

        public NakedObjectSpecification getSpecification() {
            return null;
        }

        public boolean isTransient() {
            return false;
        }

        public void parseTextEntry(String entryText) {
        }

        public String title() {
            int optionNo = PopupMenu.this.getOption();
            return ((PopupMenu)PopupMenu.this).items[optionNo].name;
        }

        public NakedObject[] getOptions() {
            return null;
        }
    }

    private static class Item {
        UserAction action;
        String description;
        boolean isBlank;
        boolean isDisabled;
        String name;
        String reasonDisabled;
        View view;

        public static Item createDivider() {
            Item item = new Item();
            item.isBlank = true;
            return item;
        }

        public static Item createNoOption() {
            Item item = new Item();
            item.name = "no options";
            return item;
        }

        public static Item createOption(UserAction action, Object object, View view, Location location) {
            Item item = new Item();
            if (action == null) {
                item.isBlank = true;
            } else {
                item.isBlank = false;
                item.action = action;
                item.view = view;
                item.name = action.getName(view);
                item.description = action.getDescription(view);
                Consent consent = action.disabled(view);
                item.isDisabled = consent.isVetoed();
                item.reasonDisabled = consent.getReason();
            }
            return item;
        }

        private Item() {
        }

        public String getHelp() {
            return this.action.getHelp(this.view);
        }

        public String toString() {
            return this.isBlank ? "NONE" : this.name + " " + (this.isDisabled ? "DISABLED " : " " + this.action);
        }
    }
}

