/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.action.Button;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class ButtonBorder
extends AbstractBorder {
    private static final int BUTTON_SPACING = 5;
    private final Button[] buttons;
    private ButtonAction defaultAction;

    public ButtonBorder(ButtonAction[] actions, View view) {
        super(view);
        this.buttons = new Button[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            ButtonAction action = actions[i];
            this.buttons[i] = new Button(action, view);
            if (!action.isDefault()) continue;
            this.defaultAction = action;
        }
        this.bottom = 1 + VPADDING + this.buttons[0].getRequiredSize(new Size()).getHeight() + VPADDING;
    }

    public void draw(Canvas canvas) {
        for (int i = 0; i < this.buttons.length; ++i) {
            Canvas buttonCanvas = canvas.createSubcanvas(this.buttons[i].getBounds());
            this.buttons[i].draw(buttonCanvas);
            int buttonWidth = this.buttons[i].getSize().getWidth();
            buttonCanvas.offset(5 + buttonWidth, 0);
        }
        super.draw(canvas);
    }

    public void firstClick(Click click) {
        View button = this.overButton(click.getLocation());
        if (button == null) {
            super.firstClick(click);
        } else {
            button.firstClick(click);
        }
    }

    public Button[] getButtons() {
        return this.buttons;
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.totalButtonWidth());
        return size;
    }

    public View identify(Location location) {
        for (int i = 0; i < this.buttons.length; ++i) {
            Button button = this.buttons[i];
            if (!button.getBounds().contains(location)) continue;
            return button;
        }
        return super.identify(location);
    }

    public void keyPressed(KeyboardAction key) {
        if (key.getKeyCode() == 10 && this.defaultAction != null && this.defaultAction.disabled(this.getView()).isAllowed()) {
            key.consume();
            this.defaultAction.execute(this.getWorkspace(), this.getView(), this.getLocation());
        }
        super.keyPressed(key);
    }

    public void layout(int width) {
        int x = width / 2 - this.totalButtonWidth() / 2;
        int y = this.getSize().getHeight() - VPADDING - this.buttons[0].getRequiredSize(new Size()).getHeight();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = this.buttons[i];
            this.buttons[i].setSize(this.buttons[i].getRequiredSize(new Size()));
            this.buttons[i].setLocation(new Location(x, y));
            x += this.buttons[i].getSize().getWidth();
            x += 5;
        }
    }

    public void mouseDown(Click click) {
        View button = this.overButton(click.getLocation());
        if (button == null) {
            super.mouseDown(click);
        } else {
            button.mouseDown(click);
        }
    }

    public void mouseUp(Click click) {
        View button = this.overButton(click.getLocation());
        if (button == null) {
            super.mouseUp(click);
        } else {
            button.mouseUp(click);
        }
    }

    private View overButton(Location location) {
        for (int i = 0; i < this.buttons.length; ++i) {
            Button button = this.buttons[i];
            if (!button.getBounds().contains(location)) continue;
            return button;
        }
        return null;
    }

    public void secondClick(Click click) {
        View button = this.overButton(click.getLocation());
        if (button == null) {
            super.secondClick(click);
        }
    }

    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        this.layout(bounds.getWidth());
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.layout(size.getWidth());
    }

    public void thirdClick(Click click) {
        View button = this.overButton(click.getLocation());
        if (button == null) {
            super.thirdClick(click);
        }
    }

    private int totalButtonWidth() {
        int totalButtonWidth = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            int buttonWidth = this.buttons[i].getRequiredSize(new Size()).getWidth();
            totalButtonWidth += i > 0 ? 5 : 0;
            totalButtonWidth += buttonWidth;
        }
        return totalButtonWidth;
    }
}

