/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class DisposedObjectBorder
extends AbstractBorder {
    public DisposedObjectBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size;
    }

    public DisposedObjectBorder(View wrappedView) {
        this(2, wrappedView);
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("DisposedObjectBorder " + this.top + " pixels"));
    }

    public Drag dragStart(DragStart drag) {
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        int i;
        super.draw(canvas);
        Color color = null;
        color = Toolkit.getColor("color.invalid");
        Size s = this.getSize();
        int w = s.getWidth();
        int xExtent = s.getWidth() - this.left;
        for (i = 0; i < this.left; ++i) {
            canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
        }
        for (i = 0; i < 15; ++i) {
            canvas.drawLine(this.left, this.top + i, this.left + i, this.top, color);
            canvas.drawLine(w - this.left - this.right - 1, s.getHeight() - this.top - i - 1, w - this.left - this.right - i - 1, s.getHeight() - this.top - 1, color);
        }
    }

    public void entered() {
        this.wrappedView.entered();
        this.getFeedbackManager().setError("Destroyed objects cannot be used");
        this.markDamaged();
    }

    public void exited() {
        this.wrappedView.exited();
        this.getFeedbackManager().setError("");
        this.markDamaged();
    }

    public String toString() {
        return this.wrappedView.toString() + "/DisposedObjectBorder [" + this.getSpecification() + "]";
    }
}

