/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.FieldContent;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.viewer.border.LabelBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class DroppableLabelBorder
extends LabelBorder {
    private final ViewState labelState = new ViewState();
    private boolean overContent;

    public static View createObjectFieldLabelBorder(View wrappedView) {
        FieldContent fieldContent = (FieldContent)wrappedView.getContent();
        return new DroppableLabelBorder(fieldContent, wrappedView);
    }

    public static View createObjectParameterLabelBorder(View wrappedView) {
        ParameterContent parameterContent = (ParameterContent)wrappedView.getContent();
        return new DroppableLabelBorder(parameterContent, wrappedView);
    }

    public DroppableLabelBorder(FieldContent fieldContent, View wrappedView) {
        super(fieldContent, wrappedView);
    }

    public DroppableLabelBorder(ParameterContent fieldContent, View wrappedView) {
        super(fieldContent, wrappedView);
    }

    public ViewAreaType viewAreaType(Location location) {
        if (this.overBorder(location)) {
            return ViewAreaType.CONTENT;
        }
        return super.viewAreaType(location);
    }

    public void dragCancel(InternalDrag drag) {
        super.dragCancel(drag);
        this.labelState.clearViewIdentified();
    }

    public void drag(ContentDrag drag) {
        Location targetLocation = drag.getTargetLocation();
        if (this.overContent(targetLocation) && !this.overContent) {
            this.overContent = true;
            super.dragIn(drag);
            this.dragOutOfLabel();
        } else if (this.overBorder(targetLocation) && this.overContent) {
            this.overContent = false;
            super.dragOut(drag);
            this.dragInToLabel(drag.getSourceContent());
        }
        super.drag(drag);
    }

    public void dragIn(ContentDrag drag) {
        if (this.overContent(drag.getTargetLocation())) {
            super.dragIn(drag);
        } else {
            Content sourceContent = drag.getSourceContent();
            this.dragInToLabel(sourceContent);
            this.markDamaged();
        }
    }

    private void dragInToLabel(Content sourceContent) {
        this.overContent = false;
        Consent canDrop = this.canDrop(sourceContent);
        if (canDrop.isAllowed()) {
            this.labelState.setCanDrop();
        } else {
            this.labelState.setCantDrop();
        }
        String actionText = canDrop.isVetoed() ? canDrop.getReason() : "Set to " + sourceContent.title();
        this.getFeedbackManager().setAction(actionText);
    }

    public void dragOut(ContentDrag drag) {
        super.dragOut(drag);
        this.dragOutOfLabel();
    }

    private void dragOutOfLabel() {
        this.labelState.clearObjectIdentified();
        this.markDamaged();
    }

    public void drop(ContentDrag drag) {
        if (this.overContent(drag.getTargetLocation())) {
            super.drop(drag);
        } else {
            this.dragOutOfLabel();
            Content sourceContent = drag.getSourceContent();
            if (this.canDrop(sourceContent).isAllowed()) {
                this.drop(sourceContent);
            }
        }
    }

    protected Consent canDrop(Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)dropContent).getObject();
            ObjectContent content = (ObjectContent)this.getContent();
            return content.canSet(source);
        }
        return Veto.DEFAULT;
    }

    protected void drop(Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject object = ((ObjectContent)dropContent).getObject();
            ((ObjectContent)this.getContent()).setObject(object);
            this.getParent().invalidateContent();
        }
    }

    protected Color textColor() {
        Color color = this.labelState.canDrop() ? Toolkit.getColor("color.valid") : (this.labelState.cantDrop() ? Toolkit.getColor("color.invalid") : super.textColor());
        return color;
    }
}

