/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.FieldContent;
import org.nakedobjects.plugins.dndviewer.LabelAxis;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;

public class LabelBorder
extends AbstractBorder {
    public static final int NORMAL = 0;
    public static final int DISABLED = 1;
    public static final int MANDATORY = 2;
    private final String label;
    private final Text style;
    private final Color color;

    public static View createFieldLabelBorder(View wrappedView) {
        FieldContent fieldContent = (FieldContent)wrappedView.getContent();
        return new LabelBorder(fieldContent, wrappedView);
    }

    public static View createValueParameterLabelBorder(View wrappedView) {
        ParameterContent fieldContent = (ParameterContent)wrappedView.getContent();
        return new LabelBorder(fieldContent, wrappedView);
    }

    protected LabelBorder(FieldContent fieldContent, View wrappedView) {
        super(wrappedView);
        if (fieldContent.isEditable().isVetoed()) {
            this.style = Toolkit.getText("text.label.disabled");
            this.color = Toolkit.getColor("color.label.disabled");
        } else if (fieldContent.isMandatory()) {
            this.style = Toolkit.getText("text.label.mandatory");
            this.color = Toolkit.getColor("color.label.mandatory");
        } else {
            this.style = Toolkit.getText("text.label");
            this.color = Toolkit.getColor("color.label.normal");
        }
        String name = fieldContent.getFieldName();
        this.label = name + ":";
        int width = HPADDING + this.style.stringWidth(this.label) + HPADDING;
        if (this.getViewAxis() == null) {
            this.left = width;
        } else {
            ((LabelAxis)this.getViewAxis()).accommodateWidth(width);
        }
    }

    protected LabelBorder(ParameterContent fieldContent, View wrappedView) {
        super(wrappedView);
        if (fieldContent.isRequired()) {
            this.style = Toolkit.getText("text.label.mandatory");
            this.color = Toolkit.getColor("color.primary1");
        } else {
            this.style = Toolkit.getText("text.label");
            this.color = Toolkit.getColor("color.primary1");
        }
        String name = fieldContent.getParameterName();
        this.label = name + ":";
        int width = HPADDING + this.style.stringWidth(this.label) + HPADDING;
        if (this.getViewAxis() == null) {
            this.left = width;
        } else {
            ((LabelAxis)this.getViewAxis()).accommodateWidth(width);
        }
    }

    protected int getLeft() {
        if (this.getViewAxis() == null) {
            return this.left;
        }
        return ((LabelAxis)this.getViewAxis()).getWidth();
    }

    public void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("label", (Object)("'" + this.label + "'"));
    }

    public void draw(Canvas canvas) {
        Color color = this.textColor();
        canvas.drawText(this.label, HPADDING, this.wrappedView.getBaseline(), color, this.style);
        super.draw(canvas);
    }

    protected Color textColor() {
        return this.color;
    }

    public String toString() {
        return this.wrappedView.toString() + "/" + ToString.name((Object)this);
    }
}

