/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.viewer.action.WindowControl;
import org.nakedobjects.plugins.dndviewer.viewer.border.BorderDrawing;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;

public class SimpleStyleWindowBorder
implements BorderDrawing {
    protected static final int LINE_THICKNESS = 5;
    private static final Text TITLE_STYLE = Toolkit.getText("text.title.small");
    int titlebarHeight = Math.max(13 + View.VPADDING + TITLE_STYLE.getDescent(), TITLE_STYLE.getTextHeight());
    int baseline = 18;
    int left = 5;
    int right = 5;
    int top = 5 + this.titlebarHeight;
    int bottom = 5;

    public void debugDetails(DebugString debug) {
        debug.append((Object)("WindowBorder " + this.left + " pixels\n"));
        debug.append((Object)("           titlebar " + (this.top - this.titlebarHeight) + " pixels"));
    }

    public void layoutControls(Size size, WindowControl[] controls) {
        int x = this.left + View.HPADDING;
        int y = 5 + View.VPADDING;
        for (int i = 0; i < controls.length; ++i) {
            controls[i].setSize(controls[i].getRequiredSize(new Size()));
            controls[i].setLocation(new Location(x, y));
            x += controls[i].getSize().getWidth() + View.HPADDING;
        }
    }

    public void draw(Canvas canvas, Size s, boolean hasFocus, ViewState state, WindowControl[] controls, String title) {
        int x = this.left;
        int width = s.getWidth();
        int height = s.getHeight();
        Color borderColor = hasFocus ? Toolkit.getColor("color.primary1") : Toolkit.getColor("color.secondary1");
        canvas.drawRoundedRectangle(0, 0, width, height, 8, 8, borderColor);
        Color titleBarTextColor = hasFocus ? Toolkit.getColor("color.black") : Toolkit.getColor("color.secondary1");
        Color titleBarBackgroundColor = hasFocus ? Toolkit.getColor("color.primary3") : Toolkit.getColor("color.secondary3");
        canvas.drawSolidRectangle(this.left, 5, width - this.left - this.right, this.titlebarHeight, titleBarBackgroundColor);
        int y = 5 + this.titlebarHeight - 1;
        canvas.drawLine(x, y, width - this.right - 1, y, borderColor);
        canvas.drawText(title, x + View.HPADDING + (15 + View.HPADDING) * controls.length, this.baseline, titleBarTextColor, TITLE_STYLE);
    }

    public void drawTransientMarker(Canvas canvas, Size size) {
        int height = this.top - 5 - 2;
        int x = size.getWidth() - 50;
        Image icon = ImageFactory.getInstance().loadIcon("transient", height, null);
        if (icon == null) {
            canvas.drawText("*", x, this.baseline, Toolkit.getColor("color.black"), Toolkit.getText("text.normal"));
        } else {
            canvas.drawImage(icon, x, 6, height, height);
        }
    }

    public void getRequiredSize(Size size, String title, WindowControl[] controls) {
        int width = this.left + View.HPADDING + TITLE_STYLE.stringWidth(title) + View.HPADDING + controls.length * (15 + View.HPADDING) + View.HPADDING + this.right;
        size.ensureWidth(width);
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }
}

