/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public abstract class AbstractObjectOption
extends AbstractUserAction {
    protected final NakedObjectAction action;
    protected final NakedObject target;

    protected AbstractObjectOption(NakedObjectAction action, NakedObject target, String name) {
        super(name);
        this.action = action;
        this.target = target;
    }

    public Consent disabled(View view) {
        NakedObject adapter = view.getContent().getNaked();
        if (adapter != null && adapter.getResolveState().isDestroyed()) {
            return new Veto("Can't do anything with a destroyed object");
        }
        Consent usableForUser = this.action.isUsable(NakedObjectsContext.getAuthenticationSession(), this.target);
        if (usableForUser.isVetoed()) {
            return usableForUser;
        }
        Consent validParameters = this.checkValid();
        if (validParameters != null && validParameters.isVetoed()) {
            return validParameters;
        }
        String desc = this.action.getDescription();
        String description = this.getName(view) + (desc.length() == 0 ? "" : ": " + desc);
        return new Allow(description);
    }

    protected Consent checkValid() {
        return null;
    }

    public String getHelp(View view) {
        return this.action.getHelp();
    }

    public NakedObjectActionType getType() {
        return this.action.getType();
    }

    public String toString() {
        return new ToString((Object)this).append("action", (Object)this.action).toString();
    }
}

